/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Caches;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CachedContent;
import com.google.genai.types.CreateCachedContentConfig;
import com.google.genai.types.DeleteCachedContentConfig;
import com.google.genai.types.DeleteCachedContentResponse;
import com.google.genai.types.GetCachedContentConfig;
import com.google.genai.types.ListCachedContentsConfig;
import com.google.genai.types.ListCachedContentsResponse;
import com.google.genai.types.UpdateCachedContentConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncCaches {
    Caches caches;
    ApiClient apiClient;

    public AsyncCaches(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.caches = new Caches(apiClient);
    }

    public CompletableFuture<CachedContent> create(String model, CreateCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.caches.buildRequestForCreate(model, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                CachedContent cachedContent = this.caches.processResponseForCreate(res, config);
                return cachedContent;
            }
        });
    }

    public CompletableFuture<CachedContent> get(String name, GetCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.caches.buildRequestForGet(name, config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                CachedContent cachedContent = this.caches.processResponseForGet(res, config);
                return cachedContent;
            }
        });
    }

    public CompletableFuture<DeleteCachedContentResponse> delete(String name, DeleteCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.caches.buildRequestForDelete(name, config);
        return this.apiClient.asyncRequest("delete", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                DeleteCachedContentResponse deleteCachedContentResponse = this.caches.processResponseForDelete(res, config);
                return deleteCachedContentResponse;
            }
        });
    }

    public CompletableFuture<CachedContent> update(String name, UpdateCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.caches.buildRequestForUpdate(name, config);
        return this.apiClient.asyncRequest("patch", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                CachedContent cachedContent = this.caches.processResponseForUpdate(res, config);
                return cachedContent;
            }
        });
    }

    CompletableFuture<ListCachedContentsResponse> privateList(ListCachedContentsConfig config) {
        Common.BuiltRequest builtRequest = this.caches.buildRequestForPrivateList(config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                ListCachedContentsResponse listCachedContentsResponse = this.caches.processResponseForPrivateList(res, config);
                return listCachedContentsResponse;
            }
        });
    }

    public CompletableFuture<AsyncPager<CachedContent>> list(ListCachedContentsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListCachedContentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListCachedContentsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.caches.privateList((ListCachedContentsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.CACHED_CONTENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

