/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.Operations;
import com.google.genai.types.FetchPredictOperationConfig;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GetOperationConfig;
import java.util.concurrent.CompletableFuture;

public final class AsyncOperations {
    Operations operations;
    ApiClient apiClient;

    public AsyncOperations(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.operations = new Operations(apiClient);
    }

    CompletableFuture<GenerateVideosOperation> privateGetVideosOperation(String operationName, GetOperationConfig config) {
        Common.BuiltRequest builtRequest = this.operations.buildRequestForPrivateGetVideosOperation(operationName, config);
        return this.apiClient.asyncRequest("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                GenerateVideosOperation generateVideosOperation = this.operations.processResponseForPrivateGetVideosOperation(res, config);
                return generateVideosOperation;
            }
        });
    }

    CompletableFuture<GenerateVideosOperation> privateFetchPredictVideosOperation(String operationName, String resourceName, FetchPredictOperationConfig config) {
        Common.BuiltRequest builtRequest = this.operations.buildRequestForPrivateFetchPredictVideosOperation(operationName, resourceName, config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                GenerateVideosOperation generateVideosOperation = this.operations.processResponseForPrivateFetchPredictVideosOperation(res, config);
                return generateVideosOperation;
            }
        });
    }

    public CompletableFuture<GenerateVideosOperation> getVideosOperation(GenerateVideosOperation operation, GetOperationConfig config) {
        return CompletableFuture.supplyAsync(() -> this.operations.getVideosOperation(operation, config));
    }
}

