/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Candidate;
import com.google.genai.types.CitationMetadata;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GroundingMetadata;
import com.google.genai.types.LogprobsResult;
import com.google.genai.types.SafetyRating;
import com.google.genai.types.UrlContextMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Candidate
extends JsonSerializable {
    @JsonProperty(value="content")
    public abstract Optional<Content> content();

    @JsonProperty(value="citationMetadata")
    public abstract Optional<CitationMetadata> citationMetadata();

    @JsonProperty(value="finishMessage")
    public abstract Optional<String> finishMessage();

    @JsonProperty(value="tokenCount")
    public abstract Optional<Integer> tokenCount();

    @JsonProperty(value="finishReason")
    public abstract Optional<FinishReason> finishReason();

    @JsonProperty(value="urlContextMetadata")
    public abstract Optional<UrlContextMetadata> urlContextMetadata();

    @JsonProperty(value="avgLogprobs")
    public abstract Optional<Double> avgLogprobs();

    @JsonProperty(value="groundingMetadata")
    public abstract Optional<GroundingMetadata> groundingMetadata();

    @JsonProperty(value="index")
    public abstract Optional<Integer> index();

    @JsonProperty(value="logprobsResult")
    public abstract Optional<LogprobsResult> logprobsResult();

    @JsonProperty(value="safetyRatings")
    public abstract Optional<List<SafetyRating>> safetyRatings();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Candidate.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Candidate fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Candidate.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Candidate.Builder();
        }

        @JsonProperty(value="content")
        public abstract Builder content(Content var1);

        public Builder content(Content.Builder contentBuilder) {
            return this.content(contentBuilder.build());
        }

        @JsonProperty(value="citationMetadata")
        public abstract Builder citationMetadata(CitationMetadata var1);

        public Builder citationMetadata(CitationMetadata.Builder citationMetadataBuilder) {
            return this.citationMetadata(citationMetadataBuilder.build());
        }

        @JsonProperty(value="finishMessage")
        public abstract Builder finishMessage(String var1);

        @JsonProperty(value="tokenCount")
        public abstract Builder tokenCount(Integer var1);

        @JsonProperty(value="finishReason")
        public abstract Builder finishReason(FinishReason var1);

        @CanIgnoreReturnValue
        public Builder finishReason(FinishReason.Known knownType) {
            return this.finishReason(new FinishReason(knownType));
        }

        @CanIgnoreReturnValue
        public Builder finishReason(String finishReason) {
            return this.finishReason(new FinishReason(finishReason));
        }

        @JsonProperty(value="urlContextMetadata")
        public abstract Builder urlContextMetadata(UrlContextMetadata var1);

        public Builder urlContextMetadata(UrlContextMetadata.Builder urlContextMetadataBuilder) {
            return this.urlContextMetadata(urlContextMetadataBuilder.build());
        }

        @JsonProperty(value="avgLogprobs")
        public abstract Builder avgLogprobs(Double var1);

        @JsonProperty(value="groundingMetadata")
        public abstract Builder groundingMetadata(GroundingMetadata var1);

        public Builder groundingMetadata(GroundingMetadata.Builder groundingMetadataBuilder) {
            return this.groundingMetadata(groundingMetadataBuilder.build());
        }

        @JsonProperty(value="index")
        public abstract Builder index(Integer var1);

        @JsonProperty(value="logprobsResult")
        public abstract Builder logprobsResult(LogprobsResult var1);

        public Builder logprobsResult(LogprobsResult.Builder logprobsResultBuilder) {
            return this.logprobsResult(logprobsResultBuilder.build());
        }

        @JsonProperty(value="safetyRatings")
        public abstract Builder safetyRatings(List<SafetyRating> var1);

        public Builder safetyRatings(SafetyRating ... safetyRatings) {
            return this.safetyRatings(Arrays.asList(safetyRatings));
        }

        public Builder safetyRatings(SafetyRating.Builder ... safetyRatingsBuilders) {
            return this.safetyRatings((List)Arrays.asList(safetyRatingsBuilders).stream().map(SafetyRating.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        public abstract Candidate build();
    }
}

