/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.BatchJob;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.CancelBatchJobConfig;
import com.google.genai.types.CancelBatchJobParameters;
import com.google.genai.types.CreateBatchJobConfig;
import com.google.genai.types.CreateBatchJobParameters;
import com.google.genai.types.CreateEmbeddingsBatchJobConfig;
import com.google.genai.types.CreateEmbeddingsBatchJobParameters;
import com.google.genai.types.DeleteBatchJobConfig;
import com.google.genai.types.DeleteBatchJobParameters;
import com.google.genai.types.DeleteResourceJob;
import com.google.genai.types.EmbeddingsBatchJobSource;
import com.google.genai.types.GetBatchJobConfig;
import com.google.genai.types.GetBatchJobParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.ListBatchJobsConfig;
import com.google.genai.types.ListBatchJobsParameters;
import com.google.genai.types.ListBatchJobsResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.ResponseBody;

public final class Batches {
    final ApiClient apiClient;

    public Batches(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"responsesFile"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"responsesFile"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedResponses", "inlinedResponses"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"inlinedResponses", "inlinedResponses"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedResponseFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"inlinedResponses"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedEmbedContentResponses", "inlinedResponses"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlinedEmbedContentResponses"}, Common.getValueByPath(fromObject, new String[]{"inlinedEmbedContentResponses", "inlinedResponses"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"predictionsFormat"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"predictionsFormat"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsDestination", "outputUriPrefix"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsUri"}, Common.getValueByPath(fromObject, new String[]{"gcsDestination", "outputUriPrefix"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryDestination", "outputUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryDestination", "outputUri"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"predictionsFormat"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsDestination", "outputUriPrefix"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryDestination", "outputUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"fileName"}))) {
            throw new IllegalArgumentException("fileName parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"inlinedResponses"}))) {
            throw new IllegalArgumentException("inlinedResponses parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"inlinedEmbedContentResponses"}))) {
            throw new IllegalArgumentException("inlinedEmbedContentResponses parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"metadata", "displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "state"}) != null) {
            Common.setValueByPath(toObject, new String[]{"state"}, Transformers.tJobState(Common.getValueByPath(fromObject, new String[]{"metadata", "state"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "endTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"metadata", "model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "output"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dest"}, this.batchJobDestinationFromMldev(JsonSerializable.toJsonNode(Transformers.tRecvBatchJobDestination(Common.getValueByPath(fromObject, new String[]{"metadata", "output"}))), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"state"}) != null) {
            Common.setValueByPath(toObject, new String[]{"state"}, Transformers.tJobState(Common.getValueByPath(fromObject, new String[]{"state"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inputConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"src"}, this.batchJobSourceFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inputConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"outputConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dest"}, this.batchJobDestinationFromVertex(JsonSerializable.toJsonNode(Transformers.tRecvBatchJobDestination(Common.getValueByPath(fromObject, new String[]{"outputConfig"}))), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"instancesFormat"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"instancesFormat"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsSource", "uris"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsUri"}, Common.getValueByPath(fromObject, new String[]{"gcsSource", "uris"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigquerySource", "inputUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryUri"}, Common.getValueByPath(fromObject, new String[]{"bigquerySource", "inputUri"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"format"}))) {
            throw new IllegalArgumentException("format parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"gcsUri"}))) {
            throw new IllegalArgumentException("gcsUri parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}))) {
            throw new IllegalArgumentException("bigqueryUri parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedRequests"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"inlinedRequests"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedRequestToMldev(apiClient, JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"requests", "requests"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"instancesFormat"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsSource", "uris"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigquerySource", "inputUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"fileName"}))) {
            throw new IllegalArgumentException("fileName parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"inlinedRequests"}))) {
            throw new IllegalArgumentException("inlinedRequests parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cancelBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cancelBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode candidateFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"content"}) != null) {
            Common.setValueByPath(toObject, new String[]{"content"}, Common.getValueByPath(fromObject, new String[]{"content"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"citationMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationMetadata"}, this.citationMetadataFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"citationMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tokenCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"tokenCount"}, Common.getValueByPath(fromObject, new String[]{"tokenCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishReason"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishReason"}, Common.getValueByPath(fromObject, new String[]{"finishReason"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContextMetadata"}, Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"avgLogprobs"}, Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"groundingMetadata"}, Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"index"}) != null) {
            Common.setValueByPath(toObject, new String[]{"index"}, Common.getValueByPath(fromObject, new String[]{"index"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobsResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobsResult"}, Common.getValueByPath(fromObject, new String[]{"logprobsResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetyRatings"}) != null) {
            Common.setValueByPath(toObject, new String[]{"safetyRatings"}, Common.getValueByPath(fromObject, new String[]{"safetyRatings"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode citationMetadataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"citationSources"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citations"}, Common.getValueByPath(fromObject, new String[]{"citationSources"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"batch", "displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"dest"}))) {
            throw new IllegalArgumentException("dest parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dest"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"outputConfig"}, this.batchJobDestinationToVertex(JsonSerializable.toJsonNode(Transformers.tBatchJobDestination(Common.getValueByPath(fromObject, new String[]{"dest"}))), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"src"}) != null) {
            Common.setValueByPath(toObject, new String[]{"batch", "inputConfig"}, this.batchJobSourceToMldev(apiClient, JsonSerializable.toJsonNode(Transformers.tBatchJobSource(Common.getValueByPath(fromObject, new String[]{"src"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createBatchJobConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"src"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inputConfig"}, this.batchJobSourceToVertex(JsonSerializable.toJsonNode(Transformers.tBatchJobSource(Common.getValueByPath(fromObject, new String[]{"src"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createBatchJobConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createEmbeddingsBatchJobConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"batch", "displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createEmbeddingsBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"src"}) != null) {
            Common.setValueByPath(toObject, new String[]{"batch", "inputConfig"}, this.embeddingsBatchJobSourceToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"src"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createEmbeddingsBatchJobConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteResourceJobFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteResourceJobFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode embedContentBatchToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            Common.setValueByPath(toObject, new String[]{"requests[]", "request", "content"}, Transformers.tContentsForEmbed(this.apiClient, Common.getValueByPath(fromObject, new String[]{"contents"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_self"}, this.embedContentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
            Common.moveValueByPath((JsonNode)toObject, (Map<String, String>)ImmutableMap.of((Object)"requests[].*", (Object)"requests[].request.*"));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode embedContentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"taskType"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"requests[]", "taskType"}, Common.getValueByPath(fromObject, new String[]{"taskType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"title"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"requests[]", "title"}, Common.getValueByPath(fromObject, new String[]{"title"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"outputDimensionality"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"requests[]", "outputDimensionality"}, Common.getValueByPath(fromObject, new String[]{"outputDimensionality"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"mimeType"}))) {
            throw new IllegalArgumentException("mimeType parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"autoTruncate"}))) {
            throw new IllegalArgumentException("autoTruncate parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode embeddingsBatchJobSourceToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"file_name"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedRequests"}) != null) {
            Common.setValueByPath(toObject, new String[]{"requests"}, this.embedContentBatchToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlinedRequests"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentConfigToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidateCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"candidateCount"}, Common.getValueByPath(fromObject, new String[]{"candidateCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"stopSequences"}) != null) {
            Common.setValueByPath(toObject, new String[]{"stopSequences"}, Common.getValueByPath(fromObject, new String[]{"stopSequences"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseLogprobs"}, Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobs"}, Common.getValueByPath(fromObject, new String[]{"logprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"presencePenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"presencePenalty"}, Common.getValueByPath(fromObject, new String[]{"presencePenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"frequencyPenalty"}, Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(toObject, new String[]{"seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseMimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseMimeType"}, Common.getValueByPath(fromObject, new String[]{"responseMimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseSchema"}, Transformers.tSchema(Common.getValueByPath(fromObject, new String[]{"responseSchema"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"routingConfig"}))) {
            throw new IllegalArgumentException("routingConfig parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"modelSelectionConfig"}))) {
            throw new IllegalArgumentException("modelSelectionConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetySettings"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"safetySettings"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.safetySettingToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"safetySettings"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath(fromObject, new String[]{"tools"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToMldev(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, Common.getValueByPath(fromObject, new String[]{"toolConfig"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"labels"}))) {
            throw new IllegalArgumentException("labels parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContent"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"cachedContent"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"cachedContent"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speechConfig"}, Transformers.tSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"})));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}))) {
            throw new IllegalArgumentException("audioTimestamp parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingConfig"}, Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"imageConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"imageConfig"}, Common.getValueByPath(fromObject, new String[]{"imageConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidates"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"candidates"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.candidateFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"candidates"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelVersion"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelVersion"}, Common.getValueByPath(fromObject, new String[]{"modelVersion"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"promptFeedback"}) != null) {
            Common.setValueByPath(toObject, new String[]{"promptFeedback"}, Common.getValueByPath(fromObject, new String[]{"promptFeedback"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseId"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseId"}, Common.getValueByPath(fromObject, new String[]{"responseId"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"authConfig"}))) {
            throw new IllegalArgumentException("authConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"enableWidget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enableWidget"}, Common.getValueByPath(fromObject, new String[]{"enableWidget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"excludeDomains"}))) {
            throw new IllegalArgumentException("excludeDomains parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedRequestToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"request", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            ArrayNode keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"}));
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"request", "contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"request", "generationConfig"}, this.generateContentConfigToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), (ObjectNode)Common.getValueByPath((JsonNode)toObject, new String[]{"request"}, new ObjectMapper().createObjectNode())));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateContentResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"filter"}))) {
            throw new IllegalArgumentException("filter parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"filter"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "filter"}, Common.getValueByPath(fromObject, new String[]{"filter"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listBatchJobsConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listBatchJobsConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"operations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"operations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.batchJobFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"batchJobs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"batchPredictionJobs"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"batchPredictionJobs"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.batchJobFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"batchJobs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, Common.getValueByPath(fromObject, new String[]{"videoMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode safetySettingToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"method"}))) {
            throw new IllegalArgumentException("method parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"category"}) != null) {
            Common.setValueByPath(toObject, new String[]{"category"}, Common.getValueByPath(fromObject, new String[]{"category"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"threshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"threshold"}, Common.getValueByPath(fromObject, new String[]{"threshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"retrieval"}))) {
            throw new IllegalArgumentException("retrieval parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}))) {
            throw new IllegalArgumentException("enterpriseWebSearch parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, Common.getValueByPath(fromObject, new String[]{"urlContext"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForPrivateCreate(String model, BatchJobSource src, CreateBatchJobConfig config) {
        String path;
        ObjectNode body;
        CreateBatchJobParameters.Builder parameterBuilder = CreateBatchJobParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(src)) {
            parameterBuilder.src(src);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.createBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs", body.get("_url"));
        } else {
            body = this.createBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{model}:batchGenerateContent", body.get("_url")) : "{model}:batchGenerateContent";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    BatchJob processResponseForPrivateCreate(ApiResponse response, CreateBatchJobConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.batchJobFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.batchJobFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, BatchJob.class);
    }

    BatchJob privateCreate(String model, BatchJobSource src, CreateBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateCreate(model, src, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            BatchJob batchJob = this.processResponseForPrivateCreate(response, config);
            return batchJob;
        }
    }

    Common.BuiltRequest buildRequestForPrivateCreateEmbeddings(String model, EmbeddingsBatchJobSource src, CreateEmbeddingsBatchJobConfig config) {
        CreateEmbeddingsBatchJobParameters.Builder parameterBuilder = CreateEmbeddingsBatchJobParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(src)) {
            parameterBuilder.src(src);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        ObjectNode body = this.createEmbeddingsBatchJobParametersToMldev(this.apiClient, parameterNode, null);
        String path = body.get("_url") != null ? Common.formatMap("{model}:asyncBatchEmbedContent", body.get("_url")) : "{model}:asyncBatchEmbedContent";
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    BatchJob processResponseForPrivateCreateEmbeddings(ApiResponse response, CreateEmbeddingsBatchJobConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Gemini Developer client.");
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.batchJobFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, BatchJob.class);
    }

    BatchJob privateCreateEmbeddings(String model, EmbeddingsBatchJobSource src, CreateEmbeddingsBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateCreateEmbeddings(model, src, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            BatchJob batchJob = this.processResponseForPrivateCreateEmbeddings(response, config);
            return batchJob;
        }
    }

    Common.BuiltRequest buildRequestForGet(String name, GetBatchJobConfig config) {
        String path;
        ObjectNode body;
        GetBatchJobParameters.Builder parameterBuilder = GetBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}", body.get("_url"));
        } else {
            body = this.getBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}", body.get("_url")) : "batches/{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    BatchJob processResponseForGet(ApiResponse response, GetBatchJobConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.batchJobFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.batchJobFromMldev(responseNode, null);
        }
        return JsonSerializable.fromJsonNode(responseNode, BatchJob.class);
    }

    public BatchJob get(String name, GetBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForGet(name, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            BatchJob batchJob = this.processResponseForGet(response, config);
            return batchJob;
        }
    }

    Common.BuiltRequest buildRequestForCancel(String name, CancelBatchJobConfig config) {
        String path;
        ObjectNode body;
        CancelBatchJobParameters.Builder parameterBuilder = CancelBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.cancelBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}:cancel", body.get("_url"));
        } else {
            body = this.cancelBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}:cancel", body.get("_url")) : "batches/{name}:cancel";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    public void cancel(String name, CancelBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForCancel(name, config);
        ApiResponse response = this.apiClient.request("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions);
        if (response != null) {
            response.close();
        }
    }

    Common.BuiltRequest buildRequestForPrivateList(ListBatchJobsConfig config) {
        String path;
        ObjectNode body;
        ListBatchJobsParameters.Builder parameterBuilder = ListBatchJobsParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.listBatchJobsParametersToVertex(parameterNode, null);
            path = Common.formatMap("batchPredictionJobs", body.get("_url"));
        } else {
            body = this.listBatchJobsParametersToMldev(parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches", body.get("_url")) : "batches";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListBatchJobsResponse processResponseForPrivateList(ApiResponse response, ListBatchJobsConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.listBatchJobsResponseFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.listBatchJobsResponseFromMldev(responseNode, null);
        }
        ListBatchJobsResponse sdkResponse = JsonSerializable.fromJsonNode(responseNode, ListBatchJobsResponse.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    ListBatchJobsResponse privateList(ListBatchJobsConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateList(config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            ListBatchJobsResponse listBatchJobsResponse = this.processResponseForPrivateList(response, config);
            return listBatchJobsResponse;
        }
    }

    Common.BuiltRequest buildRequestForDelete(String name, DeleteBatchJobConfig config) {
        String path;
        ObjectNode body;
        DeleteBatchJobParameters.Builder parameterBuilder = DeleteBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.deleteBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}", body.get("_url"));
        } else {
            body = this.deleteBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}", body.get("_url")) : "batches/{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    DeleteResourceJob processResponseForDelete(ApiResponse response, DeleteBatchJobConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.deleteResourceJobFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.deleteResourceJobFromMldev(responseNode, null);
        }
        DeleteResourceJob sdkResponse = JsonSerializable.fromJsonNode(responseNode, DeleteResourceJob.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    public DeleteResourceJob delete(String name, DeleteBatchJobConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForDelete(name, config);
        try (ApiResponse response = this.apiClient.request("delete", builtRequest.path, builtRequest.body, builtRequest.httpOptions);){
            DeleteResourceJob deleteResourceJob = this.processResponseForDelete(response, config);
            return deleteResourceJob;
        }
    }

    public BatchJob create(String model, BatchJobSource src, CreateBatchJobConfig config) {
        if (this.apiClient.vertexAI()) {
            if (src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("inlinedRequests is not supported for Vertex AI.");
            }
            if (src.fileName().isPresent()) {
                throw new GenAiIOException("fileName is not supported for Vertex AI.");
            }
            if (src.gcsUri().isPresent() && src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("Only one of gcsUri and bigqueryUri can be set.");
            }
            if (!src.gcsUri().isPresent() && !src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("One of gcsUri and bigqueryUri must be set.");
            }
        } else {
            if (src.fileName().isPresent() && src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("Only one of fileName and InlinedRequests can be set.");
            }
            if (!src.fileName().isPresent() && !src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("one of fileName and InlinedRequests must be set.");
            }
        }
        return this.privateCreate(model, src, config);
    }

    public BatchJob createEmbeddings(String model, EmbeddingsBatchJobSource src, CreateEmbeddingsBatchJobConfig config) {
        if (this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("Vertex AI does not support batches.createEmbeddings.");
        }
        return this.privateCreateEmbeddings(model, src, config);
    }

    public Pager<BatchJob> list(ListBatchJobsConfig config) {
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListBatchJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListBatchJobsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListBatchJobsConfig)requestConfig);
        };
        return new Pager<BatchJob>(BasePager.PagedItem.BATCH_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }
}

