/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_EditImageConfig;
import com.google.genai.types.EditMode;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ImagePromptLanguage;
import com.google.genai.types.PersonGeneration;
import com.google.genai.types.SafetyFilterLevel;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EditImageConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="outputGcsUri")
    public abstract Optional<String> outputGcsUri();

    @JsonProperty(value="negativePrompt")
    public abstract Optional<String> negativePrompt();

    @JsonProperty(value="numberOfImages")
    public abstract Optional<Integer> numberOfImages();

    @JsonProperty(value="aspectRatio")
    public abstract Optional<String> aspectRatio();

    @JsonProperty(value="guidanceScale")
    public abstract Optional<Float> guidanceScale();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="safetyFilterLevel")
    public abstract Optional<SafetyFilterLevel> safetyFilterLevel();

    @JsonProperty(value="personGeneration")
    public abstract Optional<PersonGeneration> personGeneration();

    @JsonProperty(value="includeSafetyAttributes")
    public abstract Optional<Boolean> includeSafetyAttributes();

    @JsonProperty(value="includeRaiReason")
    public abstract Optional<Boolean> includeRaiReason();

    @JsonProperty(value="language")
    public abstract Optional<ImagePromptLanguage> language();

    @JsonProperty(value="outputMimeType")
    public abstract Optional<String> outputMimeType();

    @JsonProperty(value="outputCompressionQuality")
    public abstract Optional<Integer> outputCompressionQuality();

    @JsonProperty(value="addWatermark")
    public abstract Optional<Boolean> addWatermark();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="editMode")
    public abstract Optional<EditMode> editMode();

    @JsonProperty(value="baseSteps")
    public abstract Optional<Integer> baseSteps();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_EditImageConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static EditImageConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, EditImageConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_EditImageConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @JsonProperty(value="outputGcsUri")
        public abstract Builder outputGcsUri(String var1);

        @JsonProperty(value="negativePrompt")
        public abstract Builder negativePrompt(String var1);

        @JsonProperty(value="numberOfImages")
        public abstract Builder numberOfImages(Integer var1);

        @JsonProperty(value="aspectRatio")
        public abstract Builder aspectRatio(String var1);

        @JsonProperty(value="guidanceScale")
        public abstract Builder guidanceScale(Float var1);

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="safetyFilterLevel")
        public abstract Builder safetyFilterLevel(SafetyFilterLevel var1);

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(SafetyFilterLevel.Known knownType) {
            return this.safetyFilterLevel(new SafetyFilterLevel(knownType));
        }

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(String safetyFilterLevel) {
            return this.safetyFilterLevel(new SafetyFilterLevel(safetyFilterLevel));
        }

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(PersonGeneration var1);

        @CanIgnoreReturnValue
        public Builder personGeneration(PersonGeneration.Known knownType) {
            return this.personGeneration(new PersonGeneration(knownType));
        }

        @CanIgnoreReturnValue
        public Builder personGeneration(String personGeneration) {
            return this.personGeneration(new PersonGeneration(personGeneration));
        }

        @JsonProperty(value="includeSafetyAttributes")
        public abstract Builder includeSafetyAttributes(boolean var1);

        @JsonProperty(value="includeRaiReason")
        public abstract Builder includeRaiReason(boolean var1);

        @JsonProperty(value="language")
        public abstract Builder language(ImagePromptLanguage var1);

        @CanIgnoreReturnValue
        public Builder language(ImagePromptLanguage.Known knownType) {
            return this.language(new ImagePromptLanguage(knownType));
        }

        @CanIgnoreReturnValue
        public Builder language(String language) {
            return this.language(new ImagePromptLanguage(language));
        }

        @JsonProperty(value="outputMimeType")
        public abstract Builder outputMimeType(String var1);

        @JsonProperty(value="outputCompressionQuality")
        public abstract Builder outputCompressionQuality(Integer var1);

        @JsonProperty(value="addWatermark")
        public abstract Builder addWatermark(boolean var1);

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @JsonProperty(value="editMode")
        public abstract Builder editMode(EditMode var1);

        @CanIgnoreReturnValue
        public Builder editMode(EditMode.Known knownType) {
            return this.editMode(new EditMode(knownType));
        }

        @CanIgnoreReturnValue
        public Builder editMode(String editMode) {
            return this.editMode(new EditMode(editMode));
        }

        @JsonProperty(value="baseSteps")
        public abstract Builder baseSteps(Integer var1);

        public abstract EditImageConfig build();
    }
}

