/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_LiveServerContent;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GroundingMetadata;
import com.google.genai.types.Transcription;
import com.google.genai.types.TurnCompleteReason;
import com.google.genai.types.UrlContextMetadata;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveServerContent
extends JsonSerializable {
    @JsonProperty(value="modelTurn")
    public abstract Optional<Content> modelTurn();

    @JsonProperty(value="turnComplete")
    public abstract Optional<Boolean> turnComplete();

    @JsonProperty(value="interrupted")
    public abstract Optional<Boolean> interrupted();

    @JsonProperty(value="groundingMetadata")
    public abstract Optional<GroundingMetadata> groundingMetadata();

    @JsonProperty(value="generationComplete")
    public abstract Optional<Boolean> generationComplete();

    @JsonProperty(value="inputTranscription")
    public abstract Optional<Transcription> inputTranscription();

    @JsonProperty(value="outputTranscription")
    public abstract Optional<Transcription> outputTranscription();

    @JsonProperty(value="urlContextMetadata")
    public abstract Optional<UrlContextMetadata> urlContextMetadata();

    @JsonProperty(value="turnCompleteReason")
    public abstract Optional<TurnCompleteReason> turnCompleteReason();

    @JsonProperty(value="waitingForInput")
    public abstract Optional<Boolean> waitingForInput();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveServerContent.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveServerContent fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveServerContent.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveServerContent.Builder();
        }

        @JsonProperty(value="modelTurn")
        public abstract Builder modelTurn(Content var1);

        public Builder modelTurn(Content.Builder modelTurnBuilder) {
            return this.modelTurn(modelTurnBuilder.build());
        }

        @JsonProperty(value="turnComplete")
        public abstract Builder turnComplete(boolean var1);

        @JsonProperty(value="interrupted")
        public abstract Builder interrupted(boolean var1);

        @JsonProperty(value="groundingMetadata")
        public abstract Builder groundingMetadata(GroundingMetadata var1);

        public Builder groundingMetadata(GroundingMetadata.Builder groundingMetadataBuilder) {
            return this.groundingMetadata(groundingMetadataBuilder.build());
        }

        @JsonProperty(value="generationComplete")
        public abstract Builder generationComplete(boolean var1);

        @JsonProperty(value="inputTranscription")
        public abstract Builder inputTranscription(Transcription var1);

        public Builder inputTranscription(Transcription.Builder inputTranscriptionBuilder) {
            return this.inputTranscription(inputTranscriptionBuilder.build());
        }

        @JsonProperty(value="outputTranscription")
        public abstract Builder outputTranscription(Transcription var1);

        public Builder outputTranscription(Transcription.Builder outputTranscriptionBuilder) {
            return this.outputTranscription(outputTranscriptionBuilder.build());
        }

        @JsonProperty(value="urlContextMetadata")
        public abstract Builder urlContextMetadata(UrlContextMetadata var1);

        public Builder urlContextMetadata(UrlContextMetadata.Builder urlContextMetadataBuilder) {
            return this.urlContextMetadata(urlContextMetadataBuilder.build());
        }

        @JsonProperty(value="turnCompleteReason")
        public abstract Builder turnCompleteReason(TurnCompleteReason var1);

        @CanIgnoreReturnValue
        public Builder turnCompleteReason(TurnCompleteReason.Known knownType) {
            return this.turnCompleteReason(new TurnCompleteReason(knownType));
        }

        @CanIgnoreReturnValue
        public Builder turnCompleteReason(String turnCompleteReason) {
            return this.turnCompleteReason(new TurnCompleteReason(turnCompleteReason));
        }

        @JsonProperty(value="waitingForInput")
        public abstract Builder waitingForInput(boolean var1);

        public abstract LiveServerContent build();
    }
}

