/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Part;
import com.google.genai.types.Blob;
import com.google.genai.types.CodeExecutionResult;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ExecutableCode;
import com.google.genai.types.FileData;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.FunctionResponsePart;
import com.google.genai.types.VideoMetadata;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Part
extends JsonSerializable {
    @JsonProperty(value="functionCall")
    public abstract Optional<FunctionCall> functionCall();

    @JsonProperty(value="codeExecutionResult")
    public abstract Optional<CodeExecutionResult> codeExecutionResult();

    @JsonProperty(value="executableCode")
    public abstract Optional<ExecutableCode> executableCode();

    @JsonProperty(value="fileData")
    public abstract Optional<FileData> fileData();

    @JsonProperty(value="functionResponse")
    public abstract Optional<FunctionResponse> functionResponse();

    @JsonProperty(value="inlineData")
    public abstract Optional<Blob> inlineData();

    @JsonProperty(value="text")
    public abstract Optional<String> text();

    @JsonProperty(value="thought")
    public abstract Optional<Boolean> thought();

    @JsonProperty(value="thoughtSignature")
    public abstract Optional<byte[]> thoughtSignature();

    @JsonProperty(value="videoMetadata")
    public abstract Optional<VideoMetadata> videoMetadata();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Part.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Part fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Part.class);
    }

    public static Part fromText(String text) {
        return Part.builder().text(text).build();
    }

    public static Part fromUri(String fileUri, String mimeType) {
        return Part.builder().fileData(FileData.builder().fileUri(fileUri).mimeType(mimeType).build()).build();
    }

    public static Part fromBytes(byte[] bytes, String mimeType) {
        return Part.builder().inlineData(Blob.builder().data(bytes).mimeType(mimeType).build()).build();
    }

    public static Part fromFunctionCall(String name, Map<String, Object> args) {
        return Part.builder().functionCall(FunctionCall.builder().name(name).args(args).build()).build();
    }

    public static Part fromFunctionResponse(String name, Map<String, Object> response, FunctionResponsePart ... functionResponseParts) {
        return Part.builder().functionResponse(FunctionResponse.builder().name(name).response(response).parts(functionResponseParts)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Part.Builder();
        }

        @JsonProperty(value="functionCall")
        public abstract Builder functionCall(FunctionCall var1);

        public Builder functionCall(FunctionCall.Builder functionCallBuilder) {
            return this.functionCall(functionCallBuilder.build());
        }

        @JsonProperty(value="codeExecutionResult")
        public abstract Builder codeExecutionResult(CodeExecutionResult var1);

        public Builder codeExecutionResult(CodeExecutionResult.Builder codeExecutionResultBuilder) {
            return this.codeExecutionResult(codeExecutionResultBuilder.build());
        }

        @JsonProperty(value="executableCode")
        public abstract Builder executableCode(ExecutableCode var1);

        public Builder executableCode(ExecutableCode.Builder executableCodeBuilder) {
            return this.executableCode(executableCodeBuilder.build());
        }

        @JsonProperty(value="fileData")
        public abstract Builder fileData(FileData var1);

        public Builder fileData(FileData.Builder fileDataBuilder) {
            return this.fileData(fileDataBuilder.build());
        }

        @JsonProperty(value="functionResponse")
        public abstract Builder functionResponse(FunctionResponse var1);

        public Builder functionResponse(FunctionResponse.Builder functionResponseBuilder) {
            return this.functionResponse(functionResponseBuilder.build());
        }

        @JsonProperty(value="inlineData")
        public abstract Builder inlineData(Blob var1);

        public Builder inlineData(Blob.Builder inlineDataBuilder) {
            return this.inlineData(inlineDataBuilder.build());
        }

        @JsonProperty(value="text")
        public abstract Builder text(String var1);

        @JsonProperty(value="thought")
        public abstract Builder thought(boolean var1);

        @JsonProperty(value="thoughtSignature")
        public abstract Builder thoughtSignature(byte[] var1);

        @JsonProperty(value="videoMetadata")
        public abstract Builder videoMetadata(VideoMetadata var1);

        public Builder videoMetadata(VideoMetadata.Builder videoMetadataBuilder) {
            return this.videoMetadata(videoMetadataBuilder.build());
        }

        public abstract Part build();
    }
}

