/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponsePart;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.Part;
import com.google.genai.types.Tool;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

final class AfcUtil {
    private static final Logger logger = Logger.getLogger(AfcUtil.class.getName());
    private static final int DEFAULT_MAX_REMOTE_CALLS_AFC = 10;

    static boolean hasCallableTool(GenerateContentConfig config) {
        if (config == null) {
            return false;
        }
        if (!config.tools().isPresent() || config.tools().get().isEmpty()) {
            return false;
        }
        for (Tool tool : config.tools().get()) {
            if (!tool.functions().isPresent() || tool.functions().get().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static GenerateContentConfig transformGenerateContentConfig(GenerateContentConfig config) {
        GenerateContentConfig transformedConfig;
        if (config != null && config.tools().isPresent() && !config.tools().get().isEmpty()) {
            ImmutableList transformedTools = (ImmutableList)config.tools().get().stream().map(tool -> Transformers.tTool(tool)).collect(ImmutableList.toImmutableList());
            ObjectNode configNode = (ObjectNode)JsonSerializable.objectMapper.valueToTree((Object)config);
            configNode.set("tools", JsonSerializable.objectMapper.valueToTree((Object)transformedTools));
            transformedConfig = JsonSerializable.fromJsonNode((JsonNode)configNode, GenerateContentConfig.class);
        } else {
            transformedConfig = config;
        }
        return transformedConfig;
    }

    static ImmutableList<Integer> findAfcIncompatibleToolIndexes(GenerateContentConfig config) {
        if (config == null || !config.tools().isPresent() || config.tools().get().isEmpty()) {
            return ImmutableList.of();
        }
        List<Tool> tools = config.tools().get();
        ImmutableList.Builder incompatibleToolsIndexesBuilder = ImmutableList.builder();
        for (int i = 0; i < tools.size(); ++i) {
            Tool tool = tools.get(i);
            if (!tool.functionDeclarations().isPresent() || tool.functionDeclarations().get().isEmpty()) continue;
            incompatibleToolsIndexesBuilder.add((Object)i);
        }
        return incompatibleToolsIndexesBuilder.build();
    }

    static ImmutableMap<String, Method> getFunctionMap(GenerateContentConfig config) {
        ImmutableMap.Builder functionMapBuilder = ImmutableMap.builder();
        if (config != null && config.tools().isPresent() && !config.tools().get().isEmpty()) {
            for (Tool tool : config.tools().get()) {
                if (!tool.functions().isPresent() || tool.functions().get().isEmpty()) continue;
                for (Method method : tool.functions().get()) {
                    functionMapBuilder.put((Object)method.getName(), (Object)method);
                }
            }
        }
        return functionMapBuilder.buildOrThrow();
    }

    static ImmutableList<Part> getFunctionResponseParts(GenerateContentResponse response, ImmutableMap<String, Method> functionMap) {
        ImmutableList.Builder functionResponsePartsBuilder = ImmutableList.builder();
        ImmutableList<Part> responseParts = response.parts();
        ImmutableList<FunctionCall> functionCalls = response.functionCalls();
        if (responseParts == null || responseParts.isEmpty() || functionCalls == null || functionCalls.isEmpty()) {
            return functionResponsePartsBuilder.build();
        }
        for (FunctionCall functionCall : functionCalls) {
            String funcName = functionCall.name().get();
            if (funcName == null || !functionMap.containsKey((Object)funcName)) continue;
            Method method = (Method)functionMap.get((Object)funcName);
            ImmutableMap args = ImmutableMap.copyOf(functionCall.args().get());
            try {
                Object funcResponse = AfcUtil.getFunctionResponse(method, (ImmutableMap<String, Object>)args);
                if (funcResponse == null) {
                    functionResponsePartsBuilder.add((Object)Part.fromFunctionResponse(funcName, (Map<String, Object>)ImmutableMap.of((Object)"result", (Object)""), new FunctionResponsePart[0]));
                    continue;
                }
                functionResponsePartsBuilder.add((Object)Part.fromFunctionResponse(funcName, (Map<String, Object>)ImmutableMap.of((Object)"result", (Object)funcResponse), new FunctionResponsePart[0]));
            }
            catch (Exception e) {
                functionResponsePartsBuilder.add((Object)Part.fromFunctionResponse(funcName, (Map<String, Object>)ImmutableMap.of((Object)"error", (Object)e.toString()), new FunctionResponsePart[0]));
            }
        }
        return functionResponsePartsBuilder.build();
    }

    static boolean shouldDisableAfc(GenerateContentConfig config) {
        if (config == null) {
            return false;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return false;
        }
        Optional<Boolean> disable = config.automaticFunctionCalling().get().disable();
        Optional<Integer> maximumRemoteCalls = config.automaticFunctionCalling().get().maximumRemoteCalls();
        if (!disable.isPresent()) {
            return false;
        }
        if (maximumRemoteCalls.isPresent() && maximumRemoteCalls.get() <= 0) {
            logger.warning(String.format("maxRemoteCalls in AfautomaticFunctionCallingConfig %s is less than or equal to 0. Disabling automatic function calling. Please set maximumRemoteCalls to a positive integer.", maximumRemoteCalls.get()));
            return true;
        }
        if (disable.get().booleanValue() && maximumRemoteCalls.isPresent() && maximumRemoteCalls.get() > 0) {
            logger.warning(String.format("`automaticFunctionCalling.disable` is set to `true`. And `automaticFunctionCalling.maximumRemoteCalls` is a positive number %s. Disabling automatic function calling. If you want to enable automatic function calling, please set `automaticFunctionCalling.disable` to `false` or leave it unset.", maximumRemoteCalls.get()));
        }
        return disable.get();
    }

    static int getMaxRemoteCallsAfc(GenerateContentConfig config) {
        if (config == null) {
            return 10;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return 10;
        }
        if (!config.automaticFunctionCalling().get().maximumRemoteCalls().isPresent()) {
            return 10;
        }
        return config.automaticFunctionCalling().get().maximumRemoteCalls().orElse(10);
    }

    static boolean shouldAppendAfcHistory(GenerateContentConfig config) {
        if (config == null) {
            return true;
        }
        if (!config.automaticFunctionCalling().isPresent()) {
            return true;
        }
        if (!config.automaticFunctionCalling().get().ignoreCallHistory().isPresent()) {
            return true;
        }
        return config.automaticFunctionCalling().get().ignoreCallHistory().get() == false;
    }

    private static Object getFunctionResponse(Method method, ImmutableMap<String, Object> argsFromModel) throws Exception {
        ArrayList<Object> argsListFromModel = new ArrayList<Object>();
        ImmutableList methodParameterNames = (ImmutableList)Arrays.stream(method.getParameters()).map(Parameter::getName).collect(ImmutableList.toImmutableList());
        for (String parameterName : methodParameterNames) {
            if (!argsFromModel.containsKey((Object)parameterName)) {
                throw new IllegalArgumentException("The parameter \"" + parameterName + "\" was not found in the function call part from model. Args in function call part from model are: " + argsFromModel);
            }
            Object argValueFromModel = argsFromModel.get((Object)parameterName);
            String className = argValueFromModel.getClass().getName();
            if (className.equals("java.lang.String")) {
                argsListFromModel.add(argValueFromModel);
                continue;
            }
            if (className.equals("java.lang.Integer")) {
                argsListFromModel.add(Integer.parseInt(argValueFromModel.toString()));
                continue;
            }
            if (className.equals("java.lang.Double")) {
                argsListFromModel.add(Double.parseDouble(argValueFromModel.toString()));
                continue;
            }
            if (className.equals("java.lang.Float")) {
                argsListFromModel.add(Float.valueOf(Float.parseFloat(argValueFromModel.toString())));
                continue;
            }
            if (className.equals("java.lang.Boolean")) {
                argsListFromModel.add(Boolean.parseBoolean(argValueFromModel.toString()));
                continue;
            }
            if (argValueFromModel instanceof List) {
                argsListFromModel.add(argValueFromModel);
                continue;
            }
            throw new IllegalArgumentException("The value type of the parameter \"" + parameterName + "\" is not supported. Supported types are String, Integer, Double, Float, Boolean, and List.");
        }
        return method.invoke(null, argsListFromModel.toArray());
    }

    private AfcUtil() {
    }
}

