/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.ApiKeyConfig;
import com.google.genai.types.AuthConfigGoogleServiceAccountConfig;
import com.google.genai.types.AuthConfigHttpBasicAuthConfig;
import com.google.genai.types.AuthConfigOauthConfig;
import com.google.genai.types.AuthConfigOidcConfig;
import com.google.genai.types.AuthType;
import com.google.genai.types.AutoValue_AuthConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuthConfig
extends JsonSerializable {
    @JsonProperty(value="apiKeyConfig")
    public abstract Optional<ApiKeyConfig> apiKeyConfig();

    @JsonProperty(value="authType")
    public abstract Optional<AuthType> authType();

    @JsonProperty(value="googleServiceAccountConfig")
    public abstract Optional<AuthConfigGoogleServiceAccountConfig> googleServiceAccountConfig();

    @JsonProperty(value="httpBasicAuthConfig")
    public abstract Optional<AuthConfigHttpBasicAuthConfig> httpBasicAuthConfig();

    @JsonProperty(value="oauthConfig")
    public abstract Optional<AuthConfigOauthConfig> oauthConfig();

    @JsonProperty(value="oidcConfig")
    public abstract Optional<AuthConfigOidcConfig> oidcConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_AuthConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static AuthConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, AuthConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_AuthConfig.Builder();
        }

        @JsonProperty(value="apiKeyConfig")
        public abstract Builder apiKeyConfig(ApiKeyConfig var1);

        @CanIgnoreReturnValue
        public Builder apiKeyConfig(ApiKeyConfig.Builder apiKeyConfigBuilder) {
            return this.apiKeyConfig(apiKeyConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiKeyConfig(Optional<ApiKeyConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiKeyConfig() {
            return this.apiKeyConfig(Optional.empty());
        }

        @JsonProperty(value="authType")
        public abstract Builder authType(AuthType var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder authType(Optional<AuthType> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAuthType() {
            return this.authType(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder authType(AuthType.Known knownType) {
            return this.authType(new AuthType(knownType));
        }

        @CanIgnoreReturnValue
        public Builder authType(String authType) {
            return this.authType(new AuthType(authType));
        }

        @JsonProperty(value="googleServiceAccountConfig")
        public abstract Builder googleServiceAccountConfig(AuthConfigGoogleServiceAccountConfig var1);

        @CanIgnoreReturnValue
        public Builder googleServiceAccountConfig(AuthConfigGoogleServiceAccountConfig.Builder googleServiceAccountConfigBuilder) {
            return this.googleServiceAccountConfig(googleServiceAccountConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder googleServiceAccountConfig(Optional<AuthConfigGoogleServiceAccountConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoogleServiceAccountConfig() {
            return this.googleServiceAccountConfig(Optional.empty());
        }

        @JsonProperty(value="httpBasicAuthConfig")
        public abstract Builder httpBasicAuthConfig(AuthConfigHttpBasicAuthConfig var1);

        @CanIgnoreReturnValue
        public Builder httpBasicAuthConfig(AuthConfigHttpBasicAuthConfig.Builder httpBasicAuthConfigBuilder) {
            return this.httpBasicAuthConfig(httpBasicAuthConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpBasicAuthConfig(Optional<AuthConfigHttpBasicAuthConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpBasicAuthConfig() {
            return this.httpBasicAuthConfig(Optional.empty());
        }

        @JsonProperty(value="oauthConfig")
        public abstract Builder oauthConfig(AuthConfigOauthConfig var1);

        @CanIgnoreReturnValue
        public Builder oauthConfig(AuthConfigOauthConfig.Builder oauthConfigBuilder) {
            return this.oauthConfig(oauthConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder oauthConfig(Optional<AuthConfigOauthConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOauthConfig() {
            return this.oauthConfig(Optional.empty());
        }

        @JsonProperty(value="oidcConfig")
        public abstract Builder oidcConfig(AuthConfigOidcConfig var1);

        @CanIgnoreReturnValue
        public Builder oidcConfig(AuthConfigOidcConfig.Builder oidcConfigBuilder) {
            return this.oidcConfig(oidcConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder oidcConfig(Optional<AuthConfigOidcConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOidcConfig() {
            return this.oidcConfig(Optional.empty());
        }

        public abstract AuthConfig build();
    }
}

