/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.FunctionCallingConfig;
import com.google.genai.types.FunctionCallingConfigMode;
import java.util.List;
import java.util.Optional;

final class AutoValue_FunctionCallingConfig
extends FunctionCallingConfig {
    private final Optional<FunctionCallingConfigMode> mode;
    private final Optional<List<String>> allowedFunctionNames;
    private final Optional<Boolean> streamFunctionCallArguments;

    private AutoValue_FunctionCallingConfig(Optional<FunctionCallingConfigMode> mode, Optional<List<String>> allowedFunctionNames, Optional<Boolean> streamFunctionCallArguments) {
        this.mode = mode;
        this.allowedFunctionNames = allowedFunctionNames;
        this.streamFunctionCallArguments = streamFunctionCallArguments;
    }

    @Override
    @JsonProperty(value="mode")
    public Optional<FunctionCallingConfigMode> mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="allowedFunctionNames")
    public Optional<List<String>> allowedFunctionNames() {
        return this.allowedFunctionNames;
    }

    @Override
    @JsonProperty(value="streamFunctionCallArguments")
    public Optional<Boolean> streamFunctionCallArguments() {
        return this.streamFunctionCallArguments;
    }

    public String toString() {
        return "FunctionCallingConfig{mode=" + this.mode + ", allowedFunctionNames=" + this.allowedFunctionNames + ", streamFunctionCallArguments=" + this.streamFunctionCallArguments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FunctionCallingConfig) {
            FunctionCallingConfig that = (FunctionCallingConfig)o;
            return this.mode.equals(that.mode()) && this.allowedFunctionNames.equals(that.allowedFunctionNames()) && this.streamFunctionCallArguments.equals(that.streamFunctionCallArguments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mode.hashCode();
        h$ *= 1000003;
        h$ ^= this.allowedFunctionNames.hashCode();
        h$ *= 1000003;
        return h$ ^= this.streamFunctionCallArguments.hashCode();
    }

    @Override
    public FunctionCallingConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FunctionCallingConfig.Builder {
        private Optional<FunctionCallingConfigMode> mode = Optional.empty();
        private Optional<List<String>> allowedFunctionNames = Optional.empty();
        private Optional<Boolean> streamFunctionCallArguments = Optional.empty();

        Builder() {
        }

        Builder(FunctionCallingConfig source) {
            this.mode = source.mode();
            this.allowedFunctionNames = source.allowedFunctionNames();
            this.streamFunctionCallArguments = source.streamFunctionCallArguments();
        }

        @Override
        public FunctionCallingConfig.Builder mode(FunctionCallingConfigMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        @Override
        FunctionCallingConfig.Builder mode(Optional<FunctionCallingConfigMode> mode) {
            if (mode == null) {
                throw new NullPointerException("Null mode");
            }
            this.mode = mode;
            return this;
        }

        @Override
        public FunctionCallingConfig.Builder allowedFunctionNames(List<String> allowedFunctionNames) {
            this.allowedFunctionNames = Optional.of(allowedFunctionNames);
            return this;
        }

        @Override
        FunctionCallingConfig.Builder allowedFunctionNames(Optional<List<String>> allowedFunctionNames) {
            if (allowedFunctionNames == null) {
                throw new NullPointerException("Null allowedFunctionNames");
            }
            this.allowedFunctionNames = allowedFunctionNames;
            return this;
        }

        @Override
        public FunctionCallingConfig.Builder streamFunctionCallArguments(boolean streamFunctionCallArguments) {
            this.streamFunctionCallArguments = Optional.of(streamFunctionCallArguments);
            return this;
        }

        @Override
        FunctionCallingConfig.Builder streamFunctionCallArguments(Optional<Boolean> streamFunctionCallArguments) {
            if (streamFunctionCallArguments == null) {
                throw new NullPointerException("Null streamFunctionCallArguments");
            }
            this.streamFunctionCallArguments = streamFunctionCallArguments;
            return this;
        }

        @Override
        public FunctionCallingConfig build() {
            return new AutoValue_FunctionCallingConfig(this.mode, this.allowedFunctionNames, this.streamFunctionCallArguments);
        }
    }
}

