/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.HttpResponse;
import java.util.Map;
import java.util.Optional;

final class AutoValue_HttpResponse
extends HttpResponse {
    private final Optional<Map<String, String>> headers;
    private final Optional<String> body;

    private AutoValue_HttpResponse(Optional<Map<String, String>> headers, Optional<String> body) {
        this.headers = headers;
        this.body = body;
    }

    @Override
    @JsonProperty(value="headers")
    public Optional<Map<String, String>> headers() {
        return this.headers;
    }

    @Override
    @JsonProperty(value="body")
    public Optional<String> body() {
        return this.body;
    }

    public String toString() {
        return "HttpResponse{headers=" + this.headers + ", body=" + this.body + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpResponse) {
            HttpResponse that = (HttpResponse)o;
            return this.headers.equals(that.headers()) && this.body.equals(that.body());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.body.hashCode();
    }

    @Override
    public HttpResponse.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends HttpResponse.Builder {
        private Optional<Map<String, String>> headers = Optional.empty();
        private Optional<String> body = Optional.empty();

        Builder() {
        }

        Builder(HttpResponse source) {
            this.headers = source.headers();
            this.body = source.body();
        }

        @Override
        public HttpResponse.Builder headers(Map<String, String> headers) {
            this.headers = Optional.of(headers);
            return this;
        }

        @Override
        HttpResponse.Builder headers(Optional<Map<String, String>> headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public HttpResponse.Builder body(String body) {
            this.body = Optional.of(body);
            return this;
        }

        @Override
        HttpResponse.Builder body(Optional<String> body) {
            if (body == null) {
                throw new NullPointerException("Null body");
            }
            this.body = body;
            return this;
        }

        @Override
        public HttpResponse build() {
            return new AutoValue_HttpResponse(this.headers, this.body);
        }
    }
}

