/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.SegmentImageConfig;
import com.google.genai.types.SegmentImageParameters;
import com.google.genai.types.SegmentImageSource;
import java.util.Optional;

final class AutoValue_SegmentImageParameters
extends SegmentImageParameters {
    private final Optional<String> model;
    private final Optional<SegmentImageSource> source;
    private final Optional<SegmentImageConfig> config;

    private AutoValue_SegmentImageParameters(Optional<String> model, Optional<SegmentImageSource> source, Optional<SegmentImageConfig> config) {
        this.model = model;
        this.source = source;
        this.config = config;
    }

    @Override
    @JsonProperty(value="model")
    public Optional<String> model() {
        return this.model;
    }

    @Override
    @JsonProperty(value="source")
    public Optional<SegmentImageSource> source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="config")
    public Optional<SegmentImageConfig> config() {
        return this.config;
    }

    public String toString() {
        return "SegmentImageParameters{model=" + this.model + ", source=" + this.source + ", config=" + this.config + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SegmentImageParameters) {
            SegmentImageParameters that = (SegmentImageParameters)o;
            return this.model.equals(that.model()) && this.source.equals(that.source()) && this.config.equals(that.config());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.source.hashCode();
        h$ *= 1000003;
        return h$ ^= this.config.hashCode();
    }

    @Override
    public SegmentImageParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SegmentImageParameters.Builder {
        private Optional<String> model = Optional.empty();
        private Optional<SegmentImageSource> source = Optional.empty();
        private Optional<SegmentImageConfig> config = Optional.empty();

        Builder() {
        }

        Builder(SegmentImageParameters source) {
            this.model = source.model();
            this.source = source.source();
            this.config = source.config();
        }

        @Override
        public SegmentImageParameters.Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        SegmentImageParameters.Builder model(Optional<String> model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public SegmentImageParameters.Builder source(SegmentImageSource source) {
            this.source = Optional.of(source);
            return this;
        }

        @Override
        SegmentImageParameters.Builder source(Optional<SegmentImageSource> source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        @Override
        public SegmentImageParameters.Builder config(SegmentImageConfig config) {
            this.config = Optional.of(config);
            return this;
        }

        @Override
        SegmentImageParameters.Builder config(Optional<SegmentImageConfig> config) {
            if (config == null) {
                throw new NullPointerException("Null config");
            }
            this.config = config;
            return this;
        }

        @Override
        public SegmentImageParameters build() {
            return new AutoValue_SegmentImageParameters(this.model, this.source, this.config);
        }
    }
}

