/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.ThinkingConfig;
import com.google.genai.types.ThinkingLevel;
import java.util.Optional;

final class AutoValue_ThinkingConfig
extends ThinkingConfig {
    private final Optional<Boolean> includeThoughts;
    private final Optional<Integer> thinkingBudget;
    private final Optional<ThinkingLevel> thinkingLevel;

    private AutoValue_ThinkingConfig(Optional<Boolean> includeThoughts, Optional<Integer> thinkingBudget, Optional<ThinkingLevel> thinkingLevel) {
        this.includeThoughts = includeThoughts;
        this.thinkingBudget = thinkingBudget;
        this.thinkingLevel = thinkingLevel;
    }

    @Override
    @JsonProperty(value="includeThoughts")
    public Optional<Boolean> includeThoughts() {
        return this.includeThoughts;
    }

    @Override
    @JsonProperty(value="thinkingBudget")
    public Optional<Integer> thinkingBudget() {
        return this.thinkingBudget;
    }

    @Override
    @JsonProperty(value="thinkingLevel")
    public Optional<ThinkingLevel> thinkingLevel() {
        return this.thinkingLevel;
    }

    public String toString() {
        return "ThinkingConfig{includeThoughts=" + this.includeThoughts + ", thinkingBudget=" + this.thinkingBudget + ", thinkingLevel=" + this.thinkingLevel + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ThinkingConfig) {
            ThinkingConfig that = (ThinkingConfig)o;
            return this.includeThoughts.equals(that.includeThoughts()) && this.thinkingBudget.equals(that.thinkingBudget()) && this.thinkingLevel.equals(that.thinkingLevel());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.includeThoughts.hashCode();
        h$ *= 1000003;
        h$ ^= this.thinkingBudget.hashCode();
        h$ *= 1000003;
        return h$ ^= this.thinkingLevel.hashCode();
    }

    @Override
    public ThinkingConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ThinkingConfig.Builder {
        private Optional<Boolean> includeThoughts = Optional.empty();
        private Optional<Integer> thinkingBudget = Optional.empty();
        private Optional<ThinkingLevel> thinkingLevel = Optional.empty();

        Builder() {
        }

        Builder(ThinkingConfig source) {
            this.includeThoughts = source.includeThoughts();
            this.thinkingBudget = source.thinkingBudget();
            this.thinkingLevel = source.thinkingLevel();
        }

        @Override
        public ThinkingConfig.Builder includeThoughts(boolean includeThoughts) {
            this.includeThoughts = Optional.of(includeThoughts);
            return this;
        }

        @Override
        ThinkingConfig.Builder includeThoughts(Optional<Boolean> includeThoughts) {
            if (includeThoughts == null) {
                throw new NullPointerException("Null includeThoughts");
            }
            this.includeThoughts = includeThoughts;
            return this;
        }

        @Override
        public ThinkingConfig.Builder thinkingBudget(Integer thinkingBudget) {
            this.thinkingBudget = Optional.of(thinkingBudget);
            return this;
        }

        @Override
        ThinkingConfig.Builder thinkingBudget(Optional<Integer> thinkingBudget) {
            if (thinkingBudget == null) {
                throw new NullPointerException("Null thinkingBudget");
            }
            this.thinkingBudget = thinkingBudget;
            return this;
        }

        @Override
        public ThinkingConfig.Builder thinkingLevel(ThinkingLevel thinkingLevel) {
            this.thinkingLevel = Optional.of(thinkingLevel);
            return this;
        }

        @Override
        ThinkingConfig.Builder thinkingLevel(Optional<ThinkingLevel> thinkingLevel) {
            if (thinkingLevel == null) {
                throw new NullPointerException("Null thinkingLevel");
            }
            this.thinkingLevel = thinkingLevel;
            return this;
        }

        @Override
        public ThinkingConfig build() {
            return new AutoValue_ThinkingConfig(this.includeThoughts, this.thinkingBudget, this.thinkingLevel);
        }
    }
}

