/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_AutoraterConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfig;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AutoraterConfig
extends JsonSerializable {
    @JsonProperty(value="samplingCount")
    public abstract Optional<Integer> samplingCount();

    @JsonProperty(value="autoraterModel")
    public abstract Optional<String> autoraterModel();

    @JsonProperty(value="generationConfig")
    public abstract Optional<GenerationConfig> generationConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_AutoraterConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static AutoraterConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, AutoraterConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_AutoraterConfig.Builder();
        }

        @JsonProperty(value="samplingCount")
        public abstract Builder samplingCount(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder samplingCount(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSamplingCount() {
            return this.samplingCount(Optional.empty());
        }

        @JsonProperty(value="autoraterModel")
        public abstract Builder autoraterModel(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder autoraterModel(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAutoraterModel() {
            return this.autoraterModel(Optional.empty());
        }

        @JsonProperty(value="generationConfig")
        public abstract Builder generationConfig(GenerationConfig var1);

        @CanIgnoreReturnValue
        public Builder generationConfig(GenerationConfig.Builder generationConfigBuilder) {
            return this.generationConfig(generationConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder generationConfig(Optional<GenerationConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGenerationConfig() {
            return this.generationConfig(Optional.empty());
        }

        public abstract AutoraterConfig build();
    }
}

