/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_BatchJobSource;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.InlinedRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class BatchJobSource
extends JsonSerializable {
    @JsonProperty(value="format")
    public abstract Optional<String> format();

    @JsonProperty(value="gcsUri")
    public abstract Optional<List<String>> gcsUri();

    @JsonProperty(value="bigqueryUri")
    public abstract Optional<String> bigqueryUri();

    @JsonProperty(value="fileName")
    public abstract Optional<String> fileName();

    @JsonProperty(value="inlinedRequests")
    public abstract Optional<List<InlinedRequest>> inlinedRequests();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_BatchJobSource.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static BatchJobSource fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, BatchJobSource.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_BatchJobSource.Builder();
        }

        @JsonProperty(value="format")
        public abstract Builder format(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder format(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFormat() {
            return this.format(Optional.empty());
        }

        @JsonProperty(value="gcsUri")
        public abstract Builder gcsUri(List<String> var1);

        @CanIgnoreReturnValue
        public Builder gcsUri(String ... gcsUri) {
            return this.gcsUri(Arrays.asList(gcsUri));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder gcsUri(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGcsUri() {
            return this.gcsUri(Optional.empty());
        }

        @JsonProperty(value="bigqueryUri")
        public abstract Builder bigqueryUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder bigqueryUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBigqueryUri() {
            return this.bigqueryUri(Optional.empty());
        }

        @JsonProperty(value="fileName")
        public abstract Builder fileName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder fileName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFileName() {
            return this.fileName(Optional.empty());
        }

        @JsonProperty(value="inlinedRequests")
        public abstract Builder inlinedRequests(List<InlinedRequest> var1);

        @CanIgnoreReturnValue
        public Builder inlinedRequests(InlinedRequest ... inlinedRequests) {
            return this.inlinedRequests(Arrays.asList(inlinedRequests));
        }

        @CanIgnoreReturnValue
        public Builder inlinedRequests(InlinedRequest.Builder ... inlinedRequestsBuilders) {
            return this.inlinedRequests((List)Arrays.asList(inlinedRequestsBuilders).stream().map(InlinedRequest.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder inlinedRequests(Optional<List<InlinedRequest>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInlinedRequests() {
            return this.inlinedRequests(Optional.empty());
        }

        public abstract BatchJobSource build();
    }
}

