/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_CountTokensConfig;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfig;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.Tool;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CountTokensConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="generationConfig")
    public abstract Optional<GenerationConfig> generationConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_CountTokensConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static CountTokensConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, CountTokensConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_CountTokensConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        @CanIgnoreReturnValue
        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder systemInstruction(Optional<Content> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSystemInstruction() {
            return this.systemInstruction(Optional.empty());
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        @CanIgnoreReturnValue
        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        @CanIgnoreReturnValue
        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tools(Optional<List<Tool>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTools() {
            return this.tools(Optional.empty());
        }

        @JsonProperty(value="generationConfig")
        public abstract Builder generationConfig(GenerationConfig var1);

        @CanIgnoreReturnValue
        public Builder generationConfig(GenerationConfig.Builder generationConfigBuilder) {
            return this.generationConfig(generationConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder generationConfig(Optional<GenerationConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGenerationConfig() {
            return this.generationConfig(Optional.empty());
        }

        public abstract CountTokensConfig build();
    }
}

