/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_DatasetDistribution;
import com.google.genai.types.DatasetDistributionDistributionBucket;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class DatasetDistribution
extends JsonSerializable {
    @JsonProperty(value="buckets")
    public abstract Optional<List<DatasetDistributionDistributionBucket>> buckets();

    @JsonProperty(value="max")
    public abstract Optional<Double> max();

    @JsonProperty(value="mean")
    public abstract Optional<Double> mean();

    @JsonProperty(value="median")
    public abstract Optional<Double> median();

    @JsonProperty(value="min")
    public abstract Optional<Double> min();

    @JsonProperty(value="p5")
    public abstract Optional<Double> p5();

    @JsonProperty(value="p95")
    public abstract Optional<Double> p95();

    @JsonProperty(value="sum")
    public abstract Optional<Double> sum();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_DatasetDistribution.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static DatasetDistribution fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, DatasetDistribution.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_DatasetDistribution.Builder();
        }

        @JsonProperty(value="buckets")
        public abstract Builder buckets(List<DatasetDistributionDistributionBucket> var1);

        @CanIgnoreReturnValue
        public Builder buckets(DatasetDistributionDistributionBucket ... buckets) {
            return this.buckets(Arrays.asList(buckets));
        }

        @CanIgnoreReturnValue
        public Builder buckets(DatasetDistributionDistributionBucket.Builder ... bucketsBuilders) {
            return this.buckets((List)Arrays.asList(bucketsBuilders).stream().map(DatasetDistributionDistributionBucket.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder buckets(Optional<List<DatasetDistributionDistributionBucket>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBuckets() {
            return this.buckets(Optional.empty());
        }

        @JsonProperty(value="max")
        public abstract Builder max(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder max(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMax() {
            return this.max(Optional.empty());
        }

        @JsonProperty(value="mean")
        public abstract Builder mean(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mean(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMean() {
            return this.mean(Optional.empty());
        }

        @JsonProperty(value="median")
        public abstract Builder median(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder median(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMedian() {
            return this.median(Optional.empty());
        }

        @JsonProperty(value="min")
        public abstract Builder min(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder min(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMin() {
            return this.min(Optional.empty());
        }

        @JsonProperty(value="p5")
        public abstract Builder p5(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder p5(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearP5() {
            return this.p5(Optional.empty());
        }

        @JsonProperty(value="p95")
        public abstract Builder p95(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder p95(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearP95() {
            return this.p95(Optional.empty());
        }

        @JsonProperty(value="sum")
        public abstract Builder sum(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sum(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSum() {
            return this.sum(Optional.empty());
        }

        public abstract DatasetDistribution build();
    }
}

