/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Document;
import com.google.genai.types.CustomMetadata;
import com.google.genai.types.DocumentState;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Document
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="state")
    public abstract Optional<DocumentState> state();

    @JsonProperty(value="sizeBytes")
    public abstract Optional<Long> sizeBytes();

    @JsonProperty(value="mimeType")
    public abstract Optional<String> mimeType();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="customMetadata")
    public abstract Optional<List<CustomMetadata>> customMetadata();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Document.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Document fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Document.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Document.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder displayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisplayName() {
            return this.displayName(Optional.empty());
        }

        @JsonProperty(value="state")
        public abstract Builder state(DocumentState var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder state(Optional<DocumentState> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearState() {
            return this.state(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder state(DocumentState.Known knownType) {
            return this.state(new DocumentState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new DocumentState(state));
        }

        @JsonProperty(value="sizeBytes")
        public abstract Builder sizeBytes(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sizeBytes(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSizeBytes() {
            return this.sizeBytes(Optional.empty());
        }

        @JsonProperty(value="mimeType")
        public abstract Builder mimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMimeType() {
            return this.mimeType(Optional.empty());
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder createTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCreateTime() {
            return this.createTime(Optional.empty());
        }

        @JsonProperty(value="customMetadata")
        public abstract Builder customMetadata(List<CustomMetadata> var1);

        @CanIgnoreReturnValue
        public Builder customMetadata(CustomMetadata ... customMetadata) {
            return this.customMetadata(Arrays.asList(customMetadata));
        }

        @CanIgnoreReturnValue
        public Builder customMetadata(CustomMetadata.Builder ... customMetadataBuilders) {
            return this.customMetadata((List)Arrays.asList(customMetadataBuilders).stream().map(CustomMetadata.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder customMetadata(Optional<List<CustomMetadata>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCustomMetadata() {
            return this.customMetadata(Optional.empty());
        }

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder updateTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpdateTime() {
            return this.updateTime(Optional.empty());
        }

        public abstract Document build();
    }
}

