/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_EmbedContentConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EmbedContentConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="taskType")
    public abstract Optional<String> taskType();

    @JsonProperty(value="title")
    public abstract Optional<String> title();

    @JsonProperty(value="outputDimensionality")
    public abstract Optional<Integer> outputDimensionality();

    @JsonProperty(value="mimeType")
    public abstract Optional<String> mimeType();

    @JsonProperty(value="autoTruncate")
    public abstract Optional<Boolean> autoTruncate();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_EmbedContentConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static EmbedContentConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, EmbedContentConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_EmbedContentConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="taskType")
        public abstract Builder taskType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder taskType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTaskType() {
            return this.taskType(Optional.empty());
        }

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder title(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTitle() {
            return this.title(Optional.empty());
        }

        @JsonProperty(value="outputDimensionality")
        public abstract Builder outputDimensionality(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputDimensionality(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputDimensionality() {
            return this.outputDimensionality(Optional.empty());
        }

        @JsonProperty(value="mimeType")
        public abstract Builder mimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMimeType() {
            return this.mimeType(Optional.empty());
        }

        @JsonProperty(value="autoTruncate")
        public abstract Builder autoTruncate(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder autoTruncate(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAutoTruncate() {
            return this.autoTruncate(Optional.empty());
        }

        public abstract EmbedContentConfig build();
    }
}

