/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_FunctionDeclaration;
import com.google.genai.types.Behavior;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FunctionDeclaration
extends JsonSerializable {
    @JsonProperty(value="behavior")
    public abstract Optional<Behavior> behavior();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="parameters")
    public abstract Optional<Schema> parameters();

    @JsonProperty(value="parametersJsonSchema")
    public abstract Optional<Object> parametersJsonSchema();

    @JsonProperty(value="response")
    public abstract Optional<Schema> response();

    @JsonProperty(value="responseJsonSchema")
    public abstract Optional<Object> responseJsonSchema();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_FunctionDeclaration.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static FunctionDeclaration fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FunctionDeclaration.class);
    }

    public static FunctionDeclaration fromMethod(Method method, String ... orderedParameterNames) {
        return FunctionDeclaration.fromMethod("", method, orderedParameterNames);
    }

    public static FunctionDeclaration fromMethod(String functionDescription, Method method, String ... orderedParameterNames) {
        Schema responseSchema;
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Instance methods are not supported. Please use static methods.");
        }
        Schema.Builder parametersBuilder = Schema.builder().type("OBJECT");
        Parameter[] parameters = method.getParameters();
        if (orderedParameterNames.length > 0 && orderedParameterNames.length != parameters.length) {
            throw new IllegalArgumentException("The number of parameter names passed to the orderedParameterNames argument does not match the number of parameters in the method.");
        }
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            String parameterName;
            if (orderedParameterNames.length == 0) {
                if (!parameters[i].isNamePresent()) {
                    throw new IllegalStateException("Failed to retrieve the parameter name from reflection. Please compile your code with the \"-parameters\" flag or provide parameter names manually.");
                }
                parameterName = parameters[i].getName();
            } else {
                parameterName = orderedParameterNames[i];
            }
            properties.put(parameterName, FunctionDeclaration.buildTypeSchema(parameterName, parameters[i].getParameterizedType(), "parameter "));
            required.add(parameterName);
        }
        parametersBuilder.properties(properties).required(required);
        try {
            responseSchema = FunctionDeclaration.buildTypeSchema("return type", method.getReturnType(), "");
        }
        catch (IllegalArgumentException e) {
            responseSchema = Schema.builder().title("return type").type("OBJECT").build();
        }
        return FunctionDeclaration.builder().name(method.getName()).description(functionDescription).parameters(parametersBuilder.build()).response(responseSchema).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Schema buildTypeSchema(String name, Type type, String prefix) {
        String errorMessage = "Unsupported type %s for %s%s. Currently, supported types are String, boolean, Boolean, int, Integer, Long, double, Double, float, Float, and List<T>.";
        Schema.Builder schemaBuilder = Schema.builder().title(name);
        String typeName = type.getTypeName();
        if (type instanceof Class) {
            Class parameterClass = (Class)type;
            switch (typeName = parameterClass.getName()) {
                case "java.lang.String": {
                    schemaBuilder = schemaBuilder.type("STRING");
                    return schemaBuilder.build();
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    schemaBuilder = schemaBuilder.type("BOOLEAN");
                    return schemaBuilder.build();
                }
                case "int": 
                case "java.lang.Integer": 
                case "java.lang.Long": {
                    schemaBuilder = schemaBuilder.type("INTEGER");
                    return schemaBuilder.build();
                }
                case "double": 
                case "java.lang.Double": 
                case "float": 
                case "java.lang.Float": {
                    schemaBuilder = schemaBuilder.type("NUMBER");
                    return schemaBuilder.build();
                }
                default: {
                    throw new IllegalArgumentException(String.format(errorMessage, typeName, prefix, name));
                }
            }
        } else {
            if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException(String.format(errorMessage, typeName, prefix, name));
            ParameterizedType pType = (ParameterizedType)type;
            if (!pType.getRawType().equals(List.class)) throw new IllegalArgumentException(String.format(errorMessage, pType.getRawType().getTypeName(), prefix + "item ", name));
            Type itemType = pType.getActualTypeArguments()[0];
            Schema itemSchema = FunctionDeclaration.buildTypeSchema(name + "Item", itemType, prefix);
            schemaBuilder.type("ARRAY").items(itemSchema);
        }
        return schemaBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FunctionDeclaration.Builder();
        }

        @JsonProperty(value="behavior")
        public abstract Builder behavior(Behavior var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder behavior(Optional<Behavior> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBehavior() {
            return this.behavior(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder behavior(Behavior.Known knownType) {
            return this.behavior(new Behavior(knownType));
        }

        @CanIgnoreReturnValue
        public Builder behavior(String behavior) {
            return this.behavior(new Behavior(behavior));
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder description(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDescription() {
            return this.description(Optional.empty());
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="parameters")
        public abstract Builder parameters(Schema var1);

        @CanIgnoreReturnValue
        public Builder parameters(Schema.Builder parametersBuilder) {
            return this.parameters(parametersBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder parameters(Optional<Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearParameters() {
            return this.parameters(Optional.empty());
        }

        @JsonProperty(value="parametersJsonSchema")
        public abstract Builder parametersJsonSchema(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder parametersJsonSchema(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearParametersJsonSchema() {
            return this.parametersJsonSchema(Optional.empty());
        }

        @JsonProperty(value="response")
        public abstract Builder response(Schema var1);

        @CanIgnoreReturnValue
        public Builder response(Schema.Builder responseBuilder) {
            return this.response(responseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder response(Optional<Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponse() {
            return this.response(Optional.empty());
        }

        @JsonProperty(value="responseJsonSchema")
        public abstract Builder responseJsonSchema(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseJsonSchema(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseJsonSchema() {
            return this.responseJsonSchema(Optional.empty());
        }

        public abstract FunctionDeclaration build();
    }
}

