/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateContentConfig;
import com.google.genai.types.AutomaticFunctionCallingConfig;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfigRoutingConfig;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ImageConfig;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.ModelSelectionConfig;
import com.google.genai.types.SafetySetting;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.ThinkingConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.ToolConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateContentConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="shouldReturnHttpResponse")
    public abstract Optional<Boolean> shouldReturnHttpResponse();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="candidateCount")
    public abstract Optional<Integer> candidateCount();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="stopSequences")
    public abstract Optional<List<String>> stopSequences();

    @JsonProperty(value="responseLogprobs")
    public abstract Optional<Boolean> responseLogprobs();

    @JsonProperty(value="logprobs")
    public abstract Optional<Integer> logprobs();

    @JsonProperty(value="presencePenalty")
    public abstract Optional<Float> presencePenalty();

    @JsonProperty(value="frequencyPenalty")
    public abstract Optional<Float> frequencyPenalty();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="responseMimeType")
    public abstract Optional<String> responseMimeType();

    @JsonProperty(value="responseSchema")
    public abstract Optional<Schema> responseSchema();

    @JsonProperty(value="responseJsonSchema")
    public abstract Optional<Object> responseJsonSchema();

    @JsonProperty(value="routingConfig")
    public abstract Optional<GenerationConfigRoutingConfig> routingConfig();

    @JsonProperty(value="modelSelectionConfig")
    public abstract Optional<ModelSelectionConfig> modelSelectionConfig();

    @JsonProperty(value="safetySettings")
    public abstract Optional<List<SafetySetting>> safetySettings();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="toolConfig")
    public abstract Optional<ToolConfig> toolConfig();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="cachedContent")
    public abstract Optional<String> cachedContent();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<String>> responseModalities();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="audioTimestamp")
    public abstract Optional<Boolean> audioTimestamp();

    @JsonProperty(value="automaticFunctionCalling")
    public abstract Optional<AutomaticFunctionCallingConfig> automaticFunctionCalling();

    @JsonProperty(value="thinkingConfig")
    public abstract Optional<ThinkingConfig> thinkingConfig();

    @JsonProperty(value="imageConfig")
    public abstract Optional<ImageConfig> imageConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateContentConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateContentConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateContentConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateContentConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="shouldReturnHttpResponse")
        public abstract Builder shouldReturnHttpResponse(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder shouldReturnHttpResponse(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearShouldReturnHttpResponse() {
            return this.shouldReturnHttpResponse(Optional.empty());
        }

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        @CanIgnoreReturnValue
        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder systemInstruction(Optional<Content> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSystemInstruction() {
            return this.systemInstruction(Optional.empty());
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder temperature(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTemperature() {
            return this.temperature(Optional.empty());
        }

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topP(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopP() {
            return this.topP(Optional.empty());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topK(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopK() {
            return this.topK(Optional.empty());
        }

        @JsonProperty(value="candidateCount")
        public abstract Builder candidateCount(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder candidateCount(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCandidateCount() {
            return this.candidateCount(Optional.empty());
        }

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxOutputTokens(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxOutputTokens() {
            return this.maxOutputTokens(Optional.empty());
        }

        @JsonProperty(value="stopSequences")
        public abstract Builder stopSequences(List<String> var1);

        @CanIgnoreReturnValue
        public Builder stopSequences(String ... stopSequences) {
            return this.stopSequences(Arrays.asList(stopSequences));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder stopSequences(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStopSequences() {
            return this.stopSequences(Optional.empty());
        }

        @JsonProperty(value="responseLogprobs")
        public abstract Builder responseLogprobs(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseLogprobs(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseLogprobs() {
            return this.responseLogprobs(Optional.empty());
        }

        @JsonProperty(value="logprobs")
        public abstract Builder logprobs(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder logprobs(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLogprobs() {
            return this.logprobs(Optional.empty());
        }

        @JsonProperty(value="presencePenalty")
        public abstract Builder presencePenalty(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder presencePenalty(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPresencePenalty() {
            return this.presencePenalty(Optional.empty());
        }

        @JsonProperty(value="frequencyPenalty")
        public abstract Builder frequencyPenalty(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder frequencyPenalty(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFrequencyPenalty() {
            return this.frequencyPenalty(Optional.empty());
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder seed(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeed() {
            return this.seed(Optional.empty());
        }

        @JsonProperty(value="responseMimeType")
        public abstract Builder responseMimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseMimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseMimeType() {
            return this.responseMimeType(Optional.empty());
        }

        @JsonProperty(value="responseSchema")
        public abstract Builder responseSchema(Schema var1);

        @CanIgnoreReturnValue
        public Builder responseSchema(Schema.Builder responseSchemaBuilder) {
            return this.responseSchema(responseSchemaBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseSchema(Optional<Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseSchema() {
            return this.responseSchema(Optional.empty());
        }

        @JsonProperty(value="responseJsonSchema")
        public abstract Builder responseJsonSchema(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseJsonSchema(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseJsonSchema() {
            return this.responseJsonSchema(Optional.empty());
        }

        @JsonProperty(value="routingConfig")
        public abstract Builder routingConfig(GenerationConfigRoutingConfig var1);

        @CanIgnoreReturnValue
        public Builder routingConfig(GenerationConfigRoutingConfig.Builder routingConfigBuilder) {
            return this.routingConfig(routingConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder routingConfig(Optional<GenerationConfigRoutingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRoutingConfig() {
            return this.routingConfig(Optional.empty());
        }

        @JsonProperty(value="modelSelectionConfig")
        public abstract Builder modelSelectionConfig(ModelSelectionConfig var1);

        @CanIgnoreReturnValue
        public Builder modelSelectionConfig(ModelSelectionConfig.Builder modelSelectionConfigBuilder) {
            return this.modelSelectionConfig(modelSelectionConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder modelSelectionConfig(Optional<ModelSelectionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModelSelectionConfig() {
            return this.modelSelectionConfig(Optional.empty());
        }

        @JsonProperty(value="safetySettings")
        public abstract Builder safetySettings(List<SafetySetting> var1);

        @CanIgnoreReturnValue
        public Builder safetySettings(SafetySetting ... safetySettings) {
            return this.safetySettings(Arrays.asList(safetySettings));
        }

        @CanIgnoreReturnValue
        public Builder safetySettings(SafetySetting.Builder ... safetySettingsBuilders) {
            return this.safetySettings((List)Arrays.asList(safetySettingsBuilders).stream().map(SafetySetting.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder safetySettings(Optional<List<SafetySetting>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSafetySettings() {
            return this.safetySettings(Optional.empty());
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        @CanIgnoreReturnValue
        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        @CanIgnoreReturnValue
        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tools(Optional<List<Tool>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTools() {
            return this.tools(Optional.empty());
        }

        @JsonProperty(value="toolConfig")
        public abstract Builder toolConfig(ToolConfig var1);

        @CanIgnoreReturnValue
        public Builder toolConfig(ToolConfig.Builder toolConfigBuilder) {
            return this.toolConfig(toolConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder toolConfig(Optional<ToolConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearToolConfig() {
            return this.toolConfig(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        @JsonProperty(value="cachedContent")
        public abstract Builder cachedContent(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder cachedContent(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCachedContent() {
            return this.cachedContent(Optional.empty());
        }

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<String> var1);

        @CanIgnoreReturnValue
        public Builder responseModalities(String ... responseModalities) {
            return this.responseModalities(Arrays.asList(responseModalities));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseModalities(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseModalities() {
            return this.responseModalities(Optional.empty());
        }

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mediaResolution(Optional<MediaResolution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMediaResolution() {
            return this.mediaResolution(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        @CanIgnoreReturnValue
        public Builder speechConfig(SpeechConfig.Builder speechConfigBuilder) {
            return this.speechConfig(speechConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder speechConfig(Optional<SpeechConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSpeechConfig() {
            return this.speechConfig(Optional.empty());
        }

        @JsonProperty(value="audioTimestamp")
        public abstract Builder audioTimestamp(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder audioTimestamp(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAudioTimestamp() {
            return this.audioTimestamp(Optional.empty());
        }

        @JsonProperty(value="automaticFunctionCalling")
        public abstract Builder automaticFunctionCalling(AutomaticFunctionCallingConfig var1);

        @CanIgnoreReturnValue
        public Builder automaticFunctionCalling(AutomaticFunctionCallingConfig.Builder automaticFunctionCallingBuilder) {
            return this.automaticFunctionCalling(automaticFunctionCallingBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder automaticFunctionCalling(Optional<AutomaticFunctionCallingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAutomaticFunctionCalling() {
            return this.automaticFunctionCalling(Optional.empty());
        }

        @JsonProperty(value="thinkingConfig")
        public abstract Builder thinkingConfig(ThinkingConfig var1);

        @CanIgnoreReturnValue
        public Builder thinkingConfig(ThinkingConfig.Builder thinkingConfigBuilder) {
            return this.thinkingConfig(thinkingConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinkingConfig(Optional<ThinkingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinkingConfig() {
            return this.thinkingConfig(Optional.empty());
        }

        @JsonProperty(value="imageConfig")
        public abstract Builder imageConfig(ImageConfig var1);

        @CanIgnoreReturnValue
        public Builder imageConfig(ImageConfig.Builder imageConfigBuilder) {
            return this.imageConfig(imageConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder imageConfig(Optional<ImageConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImageConfig() {
            return this.imageConfig(Optional.empty());
        }

        public abstract GenerateContentConfig build();
    }
}

