/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.OperationsConverters;
import com.google.genai.types.AutoValue_GenerateVideosOperation;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerateVideosResponse;
import com.google.genai.types.Operation;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateVideosOperation
extends Operation<GenerateVideosResponse, GenerateVideosOperation> {
    @Override
    @JsonProperty(value="response")
    public abstract Optional<GenerateVideosResponse> response();

    @Override
    public GenerateVideosOperation fromApiResponse(JsonNode apiResponse, boolean isVertexAi) {
        OperationsConverters converter = new OperationsConverters(null);
        ObjectNode response = isVertexAi ? converter.generateVideosOperationFromVertex(apiResponse, null) : converter.generateVideosOperationFromMldev(apiResponse, null);
        return JsonSerializable.fromJsonNode((JsonNode)response, GenerateVideosOperation.class);
    }

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateVideosOperation.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateVideosOperation fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateVideosOperation.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateVideosOperation.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="metadata")
        public abstract Builder metadata(Map<String, Object> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder metadata(Optional<Map<String, Object>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMetadata() {
            return this.metadata(Optional.empty());
        }

        @JsonProperty(value="done")
        public abstract Builder done(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder done(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDone() {
            return this.done(Optional.empty());
        }

        @JsonProperty(value="error")
        public abstract Builder error(Map<String, Object> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder error(Optional<Map<String, Object>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearError() {
            return this.error(Optional.empty());
        }

        @JsonProperty(value="response")
        public abstract Builder response(GenerateVideosResponse var1);

        @CanIgnoreReturnValue
        public Builder response(GenerateVideosResponse.Builder responseBuilder) {
            return this.response(responseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder response(Optional<GenerateVideosResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponse() {
            return this.response(Optional.empty());
        }

        public abstract GenerateVideosOperation build();
    }
}

