/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GroundingMetadata;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GroundingChunk;
import com.google.genai.types.GroundingMetadataSourceFlaggingUri;
import com.google.genai.types.GroundingSupport;
import com.google.genai.types.RetrievalMetadata;
import com.google.genai.types.SearchEntryPoint;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GroundingMetadata
extends JsonSerializable {
    @JsonProperty(value="googleMapsWidgetContextToken")
    public abstract Optional<String> googleMapsWidgetContextToken();

    @JsonProperty(value="groundingChunks")
    public abstract Optional<List<GroundingChunk>> groundingChunks();

    @JsonProperty(value="groundingSupports")
    public abstract Optional<List<GroundingSupport>> groundingSupports();

    @JsonProperty(value="retrievalMetadata")
    public abstract Optional<RetrievalMetadata> retrievalMetadata();

    @JsonProperty(value="retrievalQueries")
    public abstract Optional<List<String>> retrievalQueries();

    @JsonProperty(value="searchEntryPoint")
    public abstract Optional<SearchEntryPoint> searchEntryPoint();

    @JsonProperty(value="sourceFlaggingUris")
    public abstract Optional<List<GroundingMetadataSourceFlaggingUri>> sourceFlaggingUris();

    @JsonProperty(value="webSearchQueries")
    public abstract Optional<List<String>> webSearchQueries();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GroundingMetadata.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GroundingMetadata fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GroundingMetadata.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GroundingMetadata.Builder();
        }

        @JsonProperty(value="googleMapsWidgetContextToken")
        public abstract Builder googleMapsWidgetContextToken(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder googleMapsWidgetContextToken(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoogleMapsWidgetContextToken() {
            return this.googleMapsWidgetContextToken(Optional.empty());
        }

        @JsonProperty(value="groundingChunks")
        public abstract Builder groundingChunks(List<GroundingChunk> var1);

        @CanIgnoreReturnValue
        public Builder groundingChunks(GroundingChunk ... groundingChunks) {
            return this.groundingChunks(Arrays.asList(groundingChunks));
        }

        @CanIgnoreReturnValue
        public Builder groundingChunks(GroundingChunk.Builder ... groundingChunksBuilders) {
            return this.groundingChunks((List)Arrays.asList(groundingChunksBuilders).stream().map(GroundingChunk.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder groundingChunks(Optional<List<GroundingChunk>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGroundingChunks() {
            return this.groundingChunks(Optional.empty());
        }

        @JsonProperty(value="groundingSupports")
        public abstract Builder groundingSupports(List<GroundingSupport> var1);

        @CanIgnoreReturnValue
        public Builder groundingSupports(GroundingSupport ... groundingSupports) {
            return this.groundingSupports(Arrays.asList(groundingSupports));
        }

        @CanIgnoreReturnValue
        public Builder groundingSupports(GroundingSupport.Builder ... groundingSupportsBuilders) {
            return this.groundingSupports((List)Arrays.asList(groundingSupportsBuilders).stream().map(GroundingSupport.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder groundingSupports(Optional<List<GroundingSupport>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGroundingSupports() {
            return this.groundingSupports(Optional.empty());
        }

        @JsonProperty(value="retrievalMetadata")
        public abstract Builder retrievalMetadata(RetrievalMetadata var1);

        @CanIgnoreReturnValue
        public Builder retrievalMetadata(RetrievalMetadata.Builder retrievalMetadataBuilder) {
            return this.retrievalMetadata(retrievalMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder retrievalMetadata(Optional<RetrievalMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRetrievalMetadata() {
            return this.retrievalMetadata(Optional.empty());
        }

        @JsonProperty(value="retrievalQueries")
        public abstract Builder retrievalQueries(List<String> var1);

        @CanIgnoreReturnValue
        public Builder retrievalQueries(String ... retrievalQueries) {
            return this.retrievalQueries(Arrays.asList(retrievalQueries));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder retrievalQueries(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRetrievalQueries() {
            return this.retrievalQueries(Optional.empty());
        }

        @JsonProperty(value="searchEntryPoint")
        public abstract Builder searchEntryPoint(SearchEntryPoint var1);

        @CanIgnoreReturnValue
        public Builder searchEntryPoint(SearchEntryPoint.Builder searchEntryPointBuilder) {
            return this.searchEntryPoint(searchEntryPointBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder searchEntryPoint(Optional<SearchEntryPoint> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSearchEntryPoint() {
            return this.searchEntryPoint(Optional.empty());
        }

        @JsonProperty(value="sourceFlaggingUris")
        public abstract Builder sourceFlaggingUris(List<GroundingMetadataSourceFlaggingUri> var1);

        @CanIgnoreReturnValue
        public Builder sourceFlaggingUris(GroundingMetadataSourceFlaggingUri ... sourceFlaggingUris) {
            return this.sourceFlaggingUris(Arrays.asList(sourceFlaggingUris));
        }

        @CanIgnoreReturnValue
        public Builder sourceFlaggingUris(GroundingMetadataSourceFlaggingUri.Builder ... sourceFlaggingUrisBuilders) {
            return this.sourceFlaggingUris((List)Arrays.asList(sourceFlaggingUrisBuilders).stream().map(GroundingMetadataSourceFlaggingUri.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sourceFlaggingUris(Optional<List<GroundingMetadataSourceFlaggingUri>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSourceFlaggingUris() {
            return this.sourceFlaggingUris(Optional.empty());
        }

        @JsonProperty(value="webSearchQueries")
        public abstract Builder webSearchQueries(List<String> var1);

        @CanIgnoreReturnValue
        public Builder webSearchQueries(String ... webSearchQueries) {
            return this.webSearchQueries(Arrays.asList(webSearchQueries));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder webSearchQueries(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearWebSearchQueries() {
            return this.webSearchQueries(Optional.empty());
        }

        public abstract GroundingMetadata build();
    }
}

