/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_InlinedRequest;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerateContentConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class InlinedRequest
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="contents")
    public abstract Optional<List<Content>> contents();

    @JsonProperty(value="metadata")
    public abstract Optional<Map<String, String>> metadata();

    @JsonProperty(value="config")
    public abstract Optional<GenerateContentConfig> config();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_InlinedRequest.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static InlinedRequest fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, InlinedRequest.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_InlinedRequest.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="contents")
        public abstract Builder contents(List<Content> var1);

        @CanIgnoreReturnValue
        public Builder contents(Content ... contents) {
            return this.contents(Arrays.asList(contents));
        }

        @CanIgnoreReturnValue
        public Builder contents(Content.Builder ... contentsBuilders) {
            return this.contents((List)Arrays.asList(contentsBuilders).stream().map(Content.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder contents(Optional<List<Content>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearContents() {
            return this.contents(Optional.empty());
        }

        @JsonProperty(value="metadata")
        public abstract Builder metadata(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder metadata(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMetadata() {
            return this.metadata(Optional.empty());
        }

        @JsonProperty(value="config")
        public abstract Builder config(GenerateContentConfig var1);

        @CanIgnoreReturnValue
        public Builder config(GenerateContentConfig.Builder configBuilder) {
            return this.config(configBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder config(Optional<GenerateContentConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfig() {
            return this.config(Optional.empty());
        }

        public abstract InlinedRequest build();
    }
}

