/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_LiveClientMessage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.LiveClientContent;
import com.google.genai.types.LiveClientRealtimeInput;
import com.google.genai.types.LiveClientSetup;
import com.google.genai.types.LiveClientToolResponse;
import com.google.genai.types.LiveSendRealtimeInputParameters;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveClientMessage
extends JsonSerializable {
    @JsonProperty(value="setup")
    public abstract Optional<LiveClientSetup> setup();

    @JsonProperty(value="clientContent")
    public abstract Optional<LiveClientContent> clientContent();

    @JsonProperty(value="realtimeInput")
    public abstract Optional<LiveClientRealtimeInput> realtimeInput();

    @JsonProperty(value="realtimeInputParameters")
    public abstract Optional<LiveSendRealtimeInputParameters> realtimeInputParameters();

    @JsonProperty(value="toolResponse")
    public abstract Optional<LiveClientToolResponse> toolResponse();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveClientMessage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveClientMessage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveClientMessage.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveClientMessage.Builder();
        }

        @JsonProperty(value="setup")
        public abstract Builder setup(LiveClientSetup var1);

        @CanIgnoreReturnValue
        public Builder setup(LiveClientSetup.Builder setupBuilder) {
            return this.setup(setupBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder setup(Optional<LiveClientSetup> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSetup() {
            return this.setup(Optional.empty());
        }

        @JsonProperty(value="clientContent")
        public abstract Builder clientContent(LiveClientContent var1);

        @CanIgnoreReturnValue
        public Builder clientContent(LiveClientContent.Builder clientContentBuilder) {
            return this.clientContent(clientContentBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder clientContent(Optional<LiveClientContent> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearClientContent() {
            return this.clientContent(Optional.empty());
        }

        @JsonProperty(value="realtimeInput")
        public abstract Builder realtimeInput(LiveClientRealtimeInput var1);

        @CanIgnoreReturnValue
        public Builder realtimeInput(LiveClientRealtimeInput.Builder realtimeInputBuilder) {
            return this.realtimeInput(realtimeInputBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder realtimeInput(Optional<LiveClientRealtimeInput> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRealtimeInput() {
            return this.realtimeInput(Optional.empty());
        }

        @JsonProperty(value="realtimeInputParameters")
        public abstract Builder realtimeInputParameters(LiveSendRealtimeInputParameters var1);

        @CanIgnoreReturnValue
        public Builder realtimeInputParameters(LiveSendRealtimeInputParameters.Builder realtimeInputParametersBuilder) {
            return this.realtimeInputParameters(realtimeInputParametersBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder realtimeInputParameters(Optional<LiveSendRealtimeInputParameters> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRealtimeInputParameters() {
            return this.realtimeInputParameters(Optional.empty());
        }

        @JsonProperty(value="toolResponse")
        public abstract Builder toolResponse(LiveClientToolResponse var1);

        @CanIgnoreReturnValue
        public Builder toolResponse(LiveClientToolResponse.Builder toolResponseBuilder) {
            return this.toolResponse(toolResponseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder toolResponse(Optional<LiveClientToolResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearToolResponse() {
            return this.toolResponse(Optional.empty());
        }

        public abstract LiveClientMessage build();
    }
}

