/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.AutoValue_LiveClientSetup;
import com.google.genai.types.Content;
import com.google.genai.types.ContextWindowCompressionConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerationConfig;
import com.google.genai.types.ProactivityConfig;
import com.google.genai.types.RealtimeInputConfig;
import com.google.genai.types.SessionResumptionConfig;
import com.google.genai.types.Tool;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveClientSetup
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="generationConfig")
    public abstract Optional<GenerationConfig> generationConfig();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="realtimeInputConfig")
    public abstract Optional<RealtimeInputConfig> realtimeInputConfig();

    @JsonProperty(value="sessionResumption")
    public abstract Optional<SessionResumptionConfig> sessionResumption();

    @JsonProperty(value="contextWindowCompression")
    public abstract Optional<ContextWindowCompressionConfig> contextWindowCompression();

    @JsonProperty(value="inputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> inputAudioTranscription();

    @JsonProperty(value="outputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> outputAudioTranscription();

    @JsonProperty(value="proactivity")
    public abstract Optional<ProactivityConfig> proactivity();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveClientSetup.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveClientSetup fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveClientSetup.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveClientSetup.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="generationConfig")
        public abstract Builder generationConfig(GenerationConfig var1);

        @CanIgnoreReturnValue
        public Builder generationConfig(GenerationConfig.Builder generationConfigBuilder) {
            return this.generationConfig(generationConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder generationConfig(Optional<GenerationConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGenerationConfig() {
            return this.generationConfig(Optional.empty());
        }

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        @CanIgnoreReturnValue
        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder systemInstruction(Optional<Content> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSystemInstruction() {
            return this.systemInstruction(Optional.empty());
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        @CanIgnoreReturnValue
        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        @CanIgnoreReturnValue
        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tools(Optional<List<Tool>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTools() {
            return this.tools(Optional.empty());
        }

        @JsonProperty(value="realtimeInputConfig")
        public abstract Builder realtimeInputConfig(RealtimeInputConfig var1);

        @CanIgnoreReturnValue
        public Builder realtimeInputConfig(RealtimeInputConfig.Builder realtimeInputConfigBuilder) {
            return this.realtimeInputConfig(realtimeInputConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder realtimeInputConfig(Optional<RealtimeInputConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRealtimeInputConfig() {
            return this.realtimeInputConfig(Optional.empty());
        }

        @JsonProperty(value="sessionResumption")
        public abstract Builder sessionResumption(SessionResumptionConfig var1);

        @CanIgnoreReturnValue
        public Builder sessionResumption(SessionResumptionConfig.Builder sessionResumptionBuilder) {
            return this.sessionResumption(sessionResumptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sessionResumption(Optional<SessionResumptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSessionResumption() {
            return this.sessionResumption(Optional.empty());
        }

        @JsonProperty(value="contextWindowCompression")
        public abstract Builder contextWindowCompression(ContextWindowCompressionConfig var1);

        @CanIgnoreReturnValue
        public Builder contextWindowCompression(ContextWindowCompressionConfig.Builder contextWindowCompressionBuilder) {
            return this.contextWindowCompression(contextWindowCompressionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder contextWindowCompression(Optional<ContextWindowCompressionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearContextWindowCompression() {
            return this.contextWindowCompression(Optional.empty());
        }

        @JsonProperty(value="inputAudioTranscription")
        public abstract Builder inputAudioTranscription(AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public Builder inputAudioTranscription(AudioTranscriptionConfig.Builder inputAudioTranscriptionBuilder) {
            return this.inputAudioTranscription(inputAudioTranscriptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder inputAudioTranscription(Optional<AudioTranscriptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInputAudioTranscription() {
            return this.inputAudioTranscription(Optional.empty());
        }

        @JsonProperty(value="outputAudioTranscription")
        public abstract Builder outputAudioTranscription(AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public Builder outputAudioTranscription(AudioTranscriptionConfig.Builder outputAudioTranscriptionBuilder) {
            return this.outputAudioTranscription(outputAudioTranscriptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputAudioTranscription(Optional<AudioTranscriptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputAudioTranscription() {
            return this.outputAudioTranscription(Optional.empty());
        }

        @JsonProperty(value="proactivity")
        public abstract Builder proactivity(ProactivityConfig var1);

        @CanIgnoreReturnValue
        public Builder proactivity(ProactivityConfig.Builder proactivityBuilder) {
            return this.proactivity(proactivityBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder proactivity(Optional<ProactivityConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearProactivity() {
            return this.proactivity(Optional.empty());
        }

        public abstract LiveClientSetup build();
    }
}

