/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.AutoValue_LiveConnectConfig;
import com.google.genai.types.Content;
import com.google.genai.types.ContextWindowCompressionConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.Modality;
import com.google.genai.types.ProactivityConfig;
import com.google.genai.types.RealtimeInputConfig;
import com.google.genai.types.SessionResumptionConfig;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.ThinkingConfig;
import com.google.genai.types.Tool;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveConnectConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<Modality>> responseModalities();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="thinkingConfig")
    public abstract Optional<ThinkingConfig> thinkingConfig();

    @JsonProperty(value="enableAffectiveDialog")
    public abstract Optional<Boolean> enableAffectiveDialog();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="sessionResumption")
    public abstract Optional<SessionResumptionConfig> sessionResumption();

    @JsonProperty(value="inputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> inputAudioTranscription();

    @JsonProperty(value="outputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> outputAudioTranscription();

    @JsonProperty(value="realtimeInputConfig")
    public abstract Optional<RealtimeInputConfig> realtimeInputConfig();

    @JsonProperty(value="contextWindowCompression")
    public abstract Optional<ContextWindowCompressionConfig> contextWindowCompression();

    @JsonProperty(value="proactivity")
    public abstract Optional<ProactivityConfig> proactivity();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveConnectConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveConnectConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveConnectConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveConnectConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<Modality> var1);

        @CanIgnoreReturnValue
        public Builder responseModalities(Modality ... responseModalities) {
            return this.responseModalities(Arrays.asList(responseModalities));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder responseModalities(Optional<List<Modality>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResponseModalities() {
            return this.responseModalities(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(String ... responseModalities) {
            return this.responseModalitiesFromString(Arrays.asList(responseModalities));
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(Modality.Known ... knownTypes) {
            return this.responseModalitiesFromKnown(Arrays.asList(knownTypes));
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromKnown(List<Modality.Known> knownTypes) {
            ImmutableList listItems = (ImmutableList)knownTypes.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromString(List<String> responseModalities) {
            ImmutableList listItems = (ImmutableList)responseModalities.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder temperature(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTemperature() {
            return this.temperature(Optional.empty());
        }

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topP(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopP() {
            return this.topP(Optional.empty());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topK(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopK() {
            return this.topK(Optional.empty());
        }

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxOutputTokens(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxOutputTokens() {
            return this.maxOutputTokens(Optional.empty());
        }

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mediaResolution(Optional<MediaResolution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMediaResolution() {
            return this.mediaResolution(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder seed(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeed() {
            return this.seed(Optional.empty());
        }

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        @CanIgnoreReturnValue
        public Builder speechConfig(SpeechConfig.Builder speechConfigBuilder) {
            return this.speechConfig(speechConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder speechConfig(Optional<SpeechConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSpeechConfig() {
            return this.speechConfig(Optional.empty());
        }

        @JsonProperty(value="thinkingConfig")
        public abstract Builder thinkingConfig(ThinkingConfig var1);

        @CanIgnoreReturnValue
        public Builder thinkingConfig(ThinkingConfig.Builder thinkingConfigBuilder) {
            return this.thinkingConfig(thinkingConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinkingConfig(Optional<ThinkingConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinkingConfig() {
            return this.thinkingConfig(Optional.empty());
        }

        @JsonProperty(value="enableAffectiveDialog")
        public abstract Builder enableAffectiveDialog(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enableAffectiveDialog(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnableAffectiveDialog() {
            return this.enableAffectiveDialog(Optional.empty());
        }

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        @CanIgnoreReturnValue
        public Builder systemInstruction(Content.Builder systemInstructionBuilder) {
            return this.systemInstruction(systemInstructionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder systemInstruction(Optional<Content> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSystemInstruction() {
            return this.systemInstruction(Optional.empty());
        }

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        @CanIgnoreReturnValue
        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        @CanIgnoreReturnValue
        public Builder tools(Tool.Builder ... toolsBuilders) {
            return this.tools((List)Arrays.asList(toolsBuilders).stream().map(Tool.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tools(Optional<List<Tool>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTools() {
            return this.tools(Optional.empty());
        }

        @JsonProperty(value="sessionResumption")
        public abstract Builder sessionResumption(SessionResumptionConfig var1);

        @CanIgnoreReturnValue
        public Builder sessionResumption(SessionResumptionConfig.Builder sessionResumptionBuilder) {
            return this.sessionResumption(sessionResumptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sessionResumption(Optional<SessionResumptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSessionResumption() {
            return this.sessionResumption(Optional.empty());
        }

        @JsonProperty(value="inputAudioTranscription")
        public abstract Builder inputAudioTranscription(AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public Builder inputAudioTranscription(AudioTranscriptionConfig.Builder inputAudioTranscriptionBuilder) {
            return this.inputAudioTranscription(inputAudioTranscriptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder inputAudioTranscription(Optional<AudioTranscriptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInputAudioTranscription() {
            return this.inputAudioTranscription(Optional.empty());
        }

        @JsonProperty(value="outputAudioTranscription")
        public abstract Builder outputAudioTranscription(AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public Builder outputAudioTranscription(AudioTranscriptionConfig.Builder outputAudioTranscriptionBuilder) {
            return this.outputAudioTranscription(outputAudioTranscriptionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputAudioTranscription(Optional<AudioTranscriptionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputAudioTranscription() {
            return this.outputAudioTranscription(Optional.empty());
        }

        @JsonProperty(value="realtimeInputConfig")
        public abstract Builder realtimeInputConfig(RealtimeInputConfig var1);

        @CanIgnoreReturnValue
        public Builder realtimeInputConfig(RealtimeInputConfig.Builder realtimeInputConfigBuilder) {
            return this.realtimeInputConfig(realtimeInputConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder realtimeInputConfig(Optional<RealtimeInputConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRealtimeInputConfig() {
            return this.realtimeInputConfig(Optional.empty());
        }

        @JsonProperty(value="contextWindowCompression")
        public abstract Builder contextWindowCompression(ContextWindowCompressionConfig var1);

        @CanIgnoreReturnValue
        public Builder contextWindowCompression(ContextWindowCompressionConfig.Builder contextWindowCompressionBuilder) {
            return this.contextWindowCompression(contextWindowCompressionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder contextWindowCompression(Optional<ContextWindowCompressionConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearContextWindowCompression() {
            return this.contextWindowCompression(Optional.empty());
        }

        @JsonProperty(value="proactivity")
        public abstract Builder proactivity(ProactivityConfig var1);

        @CanIgnoreReturnValue
        public Builder proactivity(ProactivityConfig.Builder proactivityBuilder) {
            return this.proactivity(proactivityBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder proactivity(Optional<ProactivityConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearProactivity() {
            return this.proactivity(Optional.empty());
        }

        public abstract LiveConnectConfig build();
    }
}

