/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_RagRetrievalConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.RagRetrievalConfigFilter;
import com.google.genai.types.RagRetrievalConfigHybridSearch;
import com.google.genai.types.RagRetrievalConfigRanking;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RagRetrievalConfig
extends JsonSerializable {
    @JsonProperty(value="filter")
    public abstract Optional<RagRetrievalConfigFilter> filter();

    @JsonProperty(value="hybridSearch")
    public abstract Optional<RagRetrievalConfigHybridSearch> hybridSearch();

    @JsonProperty(value="ranking")
    public abstract Optional<RagRetrievalConfigRanking> ranking();

    @JsonProperty(value="topK")
    public abstract Optional<Integer> topK();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_RagRetrievalConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static RagRetrievalConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, RagRetrievalConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_RagRetrievalConfig.Builder();
        }

        @JsonProperty(value="filter")
        public abstract Builder filter(RagRetrievalConfigFilter var1);

        @CanIgnoreReturnValue
        public Builder filter(RagRetrievalConfigFilter.Builder filterBuilder) {
            return this.filter(filterBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder filter(Optional<RagRetrievalConfigFilter> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFilter() {
            return this.filter(Optional.empty());
        }

        @JsonProperty(value="hybridSearch")
        public abstract Builder hybridSearch(RagRetrievalConfigHybridSearch var1);

        @CanIgnoreReturnValue
        public Builder hybridSearch(RagRetrievalConfigHybridSearch.Builder hybridSearchBuilder) {
            return this.hybridSearch(hybridSearchBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder hybridSearch(Optional<RagRetrievalConfigHybridSearch> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHybridSearch() {
            return this.hybridSearch(Optional.empty());
        }

        @JsonProperty(value="ranking")
        public abstract Builder ranking(RagRetrievalConfigRanking var1);

        @CanIgnoreReturnValue
        public Builder ranking(RagRetrievalConfigRanking.Builder rankingBuilder) {
            return this.ranking(rankingBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder ranking(Optional<RagRetrievalConfigRanking> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRanking() {
            return this.ranking(Optional.empty());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topK(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopK() {
            return this.topK(Optional.empty());
        }

        public abstract RagRetrievalConfig build();
    }
}

