/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_RawReferenceImage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.ReferenceImage;
import com.google.genai.types.ReferenceImageAPI;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RawReferenceImage
extends JsonSerializable
implements ReferenceImage {
    @JsonProperty(value="referenceImage")
    public abstract Optional<Image> referenceImage();

    @JsonProperty(value="referenceId")
    public abstract Optional<Integer> referenceId();

    @JsonProperty(value="referenceType")
    public abstract Optional<String> referenceType();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_RawReferenceImage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static RawReferenceImage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, RawReferenceImage.class);
    }

    @Override
    public ReferenceImageAPI toReferenceImageAPI() {
        ReferenceImageAPI.Builder referenceImageAPIBuilder = ReferenceImageAPI.builder();
        this.referenceImage().ifPresent(referenceImageAPIBuilder::referenceImage);
        this.referenceId().ifPresent(referenceImageAPIBuilder::referenceId);
        referenceImageAPIBuilder.referenceType("REFERENCE_TYPE_RAW");
        return referenceImageAPIBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_RawReferenceImage.Builder();
        }

        @JsonProperty(value="referenceImage")
        public abstract Builder referenceImage(Image var1);

        @CanIgnoreReturnValue
        public Builder referenceImage(Image.Builder referenceImageBuilder) {
            return this.referenceImage(referenceImageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceImage(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceImage() {
            return this.referenceImage(Optional.empty());
        }

        @JsonProperty(value="referenceId")
        public abstract Builder referenceId(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceId(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceId() {
            return this.referenceId(Optional.empty());
        }

        @JsonProperty(value="referenceType")
        public abstract Builder referenceType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceType() {
            return this.referenceType(Optional.empty());
        }

        public abstract RawReferenceImage build();
    }
}

