/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.ActivityHandling;
import com.google.genai.types.AutoValue_RealtimeInputConfig;
import com.google.genai.types.AutomaticActivityDetection;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TurnCoverage;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RealtimeInputConfig
extends JsonSerializable {
    @JsonProperty(value="automaticActivityDetection")
    public abstract Optional<AutomaticActivityDetection> automaticActivityDetection();

    @JsonProperty(value="activityHandling")
    public abstract Optional<ActivityHandling> activityHandling();

    @JsonProperty(value="turnCoverage")
    public abstract Optional<TurnCoverage> turnCoverage();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_RealtimeInputConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static RealtimeInputConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, RealtimeInputConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_RealtimeInputConfig.Builder();
        }

        @JsonProperty(value="automaticActivityDetection")
        public abstract Builder automaticActivityDetection(AutomaticActivityDetection var1);

        @CanIgnoreReturnValue
        public Builder automaticActivityDetection(AutomaticActivityDetection.Builder automaticActivityDetectionBuilder) {
            return this.automaticActivityDetection(automaticActivityDetectionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder automaticActivityDetection(Optional<AutomaticActivityDetection> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAutomaticActivityDetection() {
            return this.automaticActivityDetection(Optional.empty());
        }

        @JsonProperty(value="activityHandling")
        public abstract Builder activityHandling(ActivityHandling var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder activityHandling(Optional<ActivityHandling> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearActivityHandling() {
            return this.activityHandling(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder activityHandling(ActivityHandling.Known knownType) {
            return this.activityHandling(new ActivityHandling(knownType));
        }

        @CanIgnoreReturnValue
        public Builder activityHandling(String activityHandling) {
            return this.activityHandling(new ActivityHandling(activityHandling));
        }

        @JsonProperty(value="turnCoverage")
        public abstract Builder turnCoverage(TurnCoverage var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder turnCoverage(Optional<TurnCoverage> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTurnCoverage() {
            return this.turnCoverage(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder turnCoverage(TurnCoverage.Known knownType) {
            return this.turnCoverage(new TurnCoverage(knownType));
        }

        @CanIgnoreReturnValue
        public Builder turnCoverage(String turnCoverage) {
            return this.turnCoverage(new TurnCoverage(turnCoverage));
        }

        public abstract RealtimeInputConfig build();
    }
}

