/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ReferenceImageAPI;
import com.google.genai.types.ControlReferenceConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.MaskReferenceConfig;
import com.google.genai.types.StyleReferenceConfig;
import com.google.genai.types.SubjectReferenceConfig;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ReferenceImageAPI
extends JsonSerializable {
    @JsonProperty(value="referenceImage")
    public abstract Optional<Image> referenceImage();

    @JsonProperty(value="referenceId")
    public abstract Optional<Integer> referenceId();

    @JsonProperty(value="referenceType")
    public abstract Optional<String> referenceType();

    @JsonProperty(value="maskImageConfig")
    public abstract Optional<MaskReferenceConfig> maskImageConfig();

    @JsonProperty(value="controlImageConfig")
    public abstract Optional<ControlReferenceConfig> controlImageConfig();

    @JsonProperty(value="styleImageConfig")
    public abstract Optional<StyleReferenceConfig> styleImageConfig();

    @JsonProperty(value="subjectImageConfig")
    public abstract Optional<SubjectReferenceConfig> subjectImageConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ReferenceImageAPI.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ReferenceImageAPI fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ReferenceImageAPI.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ReferenceImageAPI.Builder();
        }

        @JsonProperty(value="referenceImage")
        public abstract Builder referenceImage(Image var1);

        @CanIgnoreReturnValue
        public Builder referenceImage(Image.Builder referenceImageBuilder) {
            return this.referenceImage(referenceImageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceImage(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceImage() {
            return this.referenceImage(Optional.empty());
        }

        @JsonProperty(value="referenceId")
        public abstract Builder referenceId(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceId(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceId() {
            return this.referenceId(Optional.empty());
        }

        @JsonProperty(value="referenceType")
        public abstract Builder referenceType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceType() {
            return this.referenceType(Optional.empty());
        }

        @JsonProperty(value="maskImageConfig")
        public abstract Builder maskImageConfig(MaskReferenceConfig var1);

        @CanIgnoreReturnValue
        public Builder maskImageConfig(MaskReferenceConfig.Builder maskImageConfigBuilder) {
            return this.maskImageConfig(maskImageConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maskImageConfig(Optional<MaskReferenceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaskImageConfig() {
            return this.maskImageConfig(Optional.empty());
        }

        @JsonProperty(value="controlImageConfig")
        public abstract Builder controlImageConfig(ControlReferenceConfig var1);

        @CanIgnoreReturnValue
        public Builder controlImageConfig(ControlReferenceConfig.Builder controlImageConfigBuilder) {
            return this.controlImageConfig(controlImageConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder controlImageConfig(Optional<ControlReferenceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearControlImageConfig() {
            return this.controlImageConfig(Optional.empty());
        }

        @JsonProperty(value="styleImageConfig")
        public abstract Builder styleImageConfig(StyleReferenceConfig var1);

        @CanIgnoreReturnValue
        public Builder styleImageConfig(StyleReferenceConfig.Builder styleImageConfigBuilder) {
            return this.styleImageConfig(styleImageConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder styleImageConfig(Optional<StyleReferenceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStyleImageConfig() {
            return this.styleImageConfig(Optional.empty());
        }

        @JsonProperty(value="subjectImageConfig")
        public abstract Builder subjectImageConfig(SubjectReferenceConfig var1);

        @CanIgnoreReturnValue
        public Builder subjectImageConfig(SubjectReferenceConfig.Builder subjectImageConfigBuilder) {
            return this.subjectImageConfig(subjectImageConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder subjectImageConfig(Optional<SubjectReferenceConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSubjectImageConfig() {
            return this.subjectImageConfig(Optional.empty());
        }

        public abstract ReferenceImageAPI build();
    }
}

