/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ReplayFile;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ReplayInteraction;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ReplayFile
extends JsonSerializable {
    @JsonProperty(value="replay_id")
    public abstract Optional<String> replayId();

    @JsonProperty(value="interactions")
    public abstract Optional<List<ReplayInteraction>> interactions();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ReplayFile.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ReplayFile fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ReplayFile.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ReplayFile.Builder();
        }

        @JsonProperty(value="replay_id")
        public abstract Builder replayId(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder replayId(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReplayId() {
            return this.replayId(Optional.empty());
        }

        @JsonProperty(value="interactions")
        public abstract Builder interactions(List<ReplayInteraction> var1);

        @CanIgnoreReturnValue
        public Builder interactions(ReplayInteraction ... interactions) {
            return this.interactions(Arrays.asList(interactions));
        }

        @CanIgnoreReturnValue
        public Builder interactions(ReplayInteraction.Builder ... interactionsBuilders) {
            return this.interactions((List)Arrays.asList(interactionsBuilders).stream().map(ReplayInteraction.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder interactions(Optional<List<ReplayInteraction>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInteractions() {
            return this.interactions(Optional.empty());
        }

        public abstract ReplayFile build();
    }
}

