/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Retrieval;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ExternalApi;
import com.google.genai.types.VertexAISearch;
import com.google.genai.types.VertexRagStore;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Retrieval
extends JsonSerializable {
    @JsonProperty(value="disableAttribution")
    public abstract Optional<Boolean> disableAttribution();

    @JsonProperty(value="externalApi")
    public abstract Optional<ExternalApi> externalApi();

    @JsonProperty(value="vertexAiSearch")
    public abstract Optional<VertexAISearch> vertexAiSearch();

    @JsonProperty(value="vertexRagStore")
    public abstract Optional<VertexRagStore> vertexRagStore();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Retrieval.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Retrieval fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Retrieval.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Retrieval.Builder();
        }

        @JsonProperty(value="disableAttribution")
        public abstract Builder disableAttribution(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder disableAttribution(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisableAttribution() {
            return this.disableAttribution(Optional.empty());
        }

        @JsonProperty(value="externalApi")
        public abstract Builder externalApi(ExternalApi var1);

        @CanIgnoreReturnValue
        public Builder externalApi(ExternalApi.Builder externalApiBuilder) {
            return this.externalApi(externalApiBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder externalApi(Optional<ExternalApi> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExternalApi() {
            return this.externalApi(Optional.empty());
        }

        @JsonProperty(value="vertexAiSearch")
        public abstract Builder vertexAiSearch(VertexAISearch var1);

        @CanIgnoreReturnValue
        public Builder vertexAiSearch(VertexAISearch.Builder vertexAiSearchBuilder) {
            return this.vertexAiSearch(vertexAiSearchBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder vertexAiSearch(Optional<VertexAISearch> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVertexAiSearch() {
            return this.vertexAiSearch(Optional.empty());
        }

        @JsonProperty(value="vertexRagStore")
        public abstract Builder vertexRagStore(VertexRagStore var1);

        @CanIgnoreReturnValue
        public Builder vertexRagStore(VertexRagStore.Builder vertexRagStoreBuilder) {
            return this.vertexRagStore(vertexRagStoreBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder vertexRagStore(Optional<VertexRagStore> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVertexRagStore() {
            return this.vertexRagStore(Optional.empty());
        }

        public abstract Retrieval build();
    }
}

