/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Schema;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Schema
extends JsonSerializable {
    @JsonProperty(value="anyOf")
    public abstract Optional<List<Schema>> anyOf();

    @JsonProperty(value="default")
    public abstract Optional<Object> default_();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="enum")
    public abstract Optional<List<String>> enum_();

    @JsonProperty(value="example")
    public abstract Optional<Object> example();

    @JsonProperty(value="format")
    public abstract Optional<String> format();

    @JsonProperty(value="items")
    public abstract Optional<Schema> items();

    @JsonProperty(value="maxItems")
    public abstract Optional<Long> maxItems();

    @JsonProperty(value="maxLength")
    public abstract Optional<Long> maxLength();

    @JsonProperty(value="maxProperties")
    public abstract Optional<Long> maxProperties();

    @JsonProperty(value="maximum")
    public abstract Optional<Double> maximum();

    @JsonProperty(value="minItems")
    public abstract Optional<Long> minItems();

    @JsonProperty(value="minLength")
    public abstract Optional<Long> minLength();

    @JsonProperty(value="minProperties")
    public abstract Optional<Long> minProperties();

    @JsonProperty(value="minimum")
    public abstract Optional<Double> minimum();

    @JsonProperty(value="nullable")
    public abstract Optional<Boolean> nullable();

    @JsonProperty(value="pattern")
    public abstract Optional<String> pattern();

    @JsonProperty(value="properties")
    public abstract Optional<Map<String, Schema>> properties();

    @JsonProperty(value="propertyOrdering")
    public abstract Optional<List<String>> propertyOrdering();

    @JsonProperty(value="required")
    public abstract Optional<List<String>> required();

    @JsonProperty(value="title")
    public abstract Optional<String> title();

    @JsonProperty(value="type")
    public abstract Optional<Type> type();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Schema.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Schema fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Schema.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Schema.Builder();
        }

        @JsonProperty(value="anyOf")
        public abstract Builder anyOf(List<Schema> var1);

        @CanIgnoreReturnValue
        public Builder anyOf(Schema ... anyOf) {
            return this.anyOf(Arrays.asList(anyOf));
        }

        @CanIgnoreReturnValue
        public Builder anyOf(Builder ... anyOfBuilders) {
            return this.anyOf((List)Arrays.asList(anyOfBuilders).stream().map(Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder anyOf(Optional<List<Schema>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAnyOf() {
            return this.anyOf(Optional.empty());
        }

        @JsonProperty(value="default")
        public abstract Builder default_(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder default_(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDefault_() {
            return this.default_(Optional.empty());
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder description(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDescription() {
            return this.description(Optional.empty());
        }

        @JsonProperty(value="enum")
        public abstract Builder enum_(List<String> var1);

        @CanIgnoreReturnValue
        public Builder enum_(String ... enum_) {
            return this.enum_(Arrays.asList(enum_));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enum_(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnum_() {
            return this.enum_(Optional.empty());
        }

        @JsonProperty(value="example")
        public abstract Builder example(Object var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder example(Optional<Object> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExample() {
            return this.example(Optional.empty());
        }

        @JsonProperty(value="format")
        public abstract Builder format(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder format(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFormat() {
            return this.format(Optional.empty());
        }

        @JsonProperty(value="items")
        public abstract Builder items(Schema var1);

        @CanIgnoreReturnValue
        public Builder items(Builder itemsBuilder) {
            return this.items(itemsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder items(Optional<Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearItems() {
            return this.items(Optional.empty());
        }

        @JsonProperty(value="maxItems")
        public abstract Builder maxItems(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxItems(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxItems() {
            return this.maxItems(Optional.empty());
        }

        @JsonProperty(value="maxLength")
        public abstract Builder maxLength(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxLength(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxLength() {
            return this.maxLength(Optional.empty());
        }

        @JsonProperty(value="maxProperties")
        public abstract Builder maxProperties(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxProperties(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxProperties() {
            return this.maxProperties(Optional.empty());
        }

        @JsonProperty(value="maximum")
        public abstract Builder maximum(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maximum(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaximum() {
            return this.maximum(Optional.empty());
        }

        @JsonProperty(value="minItems")
        public abstract Builder minItems(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder minItems(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMinItems() {
            return this.minItems(Optional.empty());
        }

        @JsonProperty(value="minLength")
        public abstract Builder minLength(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder minLength(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMinLength() {
            return this.minLength(Optional.empty());
        }

        @JsonProperty(value="minProperties")
        public abstract Builder minProperties(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder minProperties(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMinProperties() {
            return this.minProperties(Optional.empty());
        }

        @JsonProperty(value="minimum")
        public abstract Builder minimum(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder minimum(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMinimum() {
            return this.minimum(Optional.empty());
        }

        @JsonProperty(value="nullable")
        public abstract Builder nullable(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder nullable(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearNullable() {
            return this.nullable(Optional.empty());
        }

        @JsonProperty(value="pattern")
        public abstract Builder pattern(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder pattern(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPattern() {
            return this.pattern(Optional.empty());
        }

        @JsonProperty(value="properties")
        public abstract Builder properties(Map<String, Schema> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder properties(Optional<Map<String, Schema>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearProperties() {
            return this.properties(Optional.empty());
        }

        @JsonProperty(value="propertyOrdering")
        public abstract Builder propertyOrdering(List<String> var1);

        @CanIgnoreReturnValue
        public Builder propertyOrdering(String ... propertyOrdering) {
            return this.propertyOrdering(Arrays.asList(propertyOrdering));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder propertyOrdering(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPropertyOrdering() {
            return this.propertyOrdering(Optional.empty());
        }

        @JsonProperty(value="required")
        public abstract Builder required(List<String> var1);

        @CanIgnoreReturnValue
        public Builder required(String ... required) {
            return this.required(Arrays.asList(required));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder required(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRequired() {
            return this.required(Optional.empty());
        }

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder title(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTitle() {
            return this.title(Optional.empty());
        }

        @JsonProperty(value="type")
        public abstract Builder type(Type var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder type(Optional<Type> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearType() {
            return this.type(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder type(Type.Known knownType) {
            return this.type(new Type(knownType));
        }

        @CanIgnoreReturnValue
        public Builder type(String type) {
            return this.type(new Type(type));
        }

        public abstract Schema build();
    }
}

