/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_SupervisedTuningDataStats;
import com.google.genai.types.Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.SupervisedTuningDatasetDistribution;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SupervisedTuningDataStats
extends JsonSerializable {
    @JsonProperty(value="droppedExampleReasons")
    public abstract Optional<List<String>> droppedExampleReasons();

    @JsonProperty(value="totalBillableCharacterCount")
    public abstract Optional<Long> totalBillableCharacterCount();

    @JsonProperty(value="totalBillableTokenCount")
    public abstract Optional<Long> totalBillableTokenCount();

    @JsonProperty(value="totalTruncatedExampleCount")
    public abstract Optional<Long> totalTruncatedExampleCount();

    @JsonProperty(value="totalTuningCharacterCount")
    public abstract Optional<Long> totalTuningCharacterCount();

    @JsonProperty(value="truncatedExampleIndices")
    public abstract Optional<List<Long>> truncatedExampleIndices();

    @JsonProperty(value="tuningDatasetExampleCount")
    public abstract Optional<Long> tuningDatasetExampleCount();

    @JsonProperty(value="tuningStepCount")
    public abstract Optional<Long> tuningStepCount();

    @JsonProperty(value="userDatasetExamples")
    public abstract Optional<List<Content>> userDatasetExamples();

    @JsonProperty(value="userInputTokenDistribution")
    public abstract Optional<SupervisedTuningDatasetDistribution> userInputTokenDistribution();

    @JsonProperty(value="userMessagePerExampleDistribution")
    public abstract Optional<SupervisedTuningDatasetDistribution> userMessagePerExampleDistribution();

    @JsonProperty(value="userOutputTokenDistribution")
    public abstract Optional<SupervisedTuningDatasetDistribution> userOutputTokenDistribution();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SupervisedTuningDataStats.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SupervisedTuningDataStats fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SupervisedTuningDataStats.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SupervisedTuningDataStats.Builder();
        }

        @JsonProperty(value="droppedExampleReasons")
        public abstract Builder droppedExampleReasons(List<String> var1);

        @CanIgnoreReturnValue
        public Builder droppedExampleReasons(String ... droppedExampleReasons) {
            return this.droppedExampleReasons(Arrays.asList(droppedExampleReasons));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder droppedExampleReasons(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDroppedExampleReasons() {
            return this.droppedExampleReasons(Optional.empty());
        }

        @JsonProperty(value="totalBillableCharacterCount")
        public abstract Builder totalBillableCharacterCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder totalBillableCharacterCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTotalBillableCharacterCount() {
            return this.totalBillableCharacterCount(Optional.empty());
        }

        @JsonProperty(value="totalBillableTokenCount")
        public abstract Builder totalBillableTokenCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder totalBillableTokenCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTotalBillableTokenCount() {
            return this.totalBillableTokenCount(Optional.empty());
        }

        @JsonProperty(value="totalTruncatedExampleCount")
        public abstract Builder totalTruncatedExampleCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder totalTruncatedExampleCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTotalTruncatedExampleCount() {
            return this.totalTruncatedExampleCount(Optional.empty());
        }

        @JsonProperty(value="totalTuningCharacterCount")
        public abstract Builder totalTuningCharacterCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder totalTuningCharacterCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTotalTuningCharacterCount() {
            return this.totalTuningCharacterCount(Optional.empty());
        }

        @JsonProperty(value="truncatedExampleIndices")
        public abstract Builder truncatedExampleIndices(List<Long> var1);

        @CanIgnoreReturnValue
        public Builder truncatedExampleIndices(Long ... truncatedExampleIndices) {
            return this.truncatedExampleIndices(Arrays.asList(truncatedExampleIndices));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder truncatedExampleIndices(Optional<List<Long>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTruncatedExampleIndices() {
            return this.truncatedExampleIndices(Optional.empty());
        }

        @JsonProperty(value="tuningDatasetExampleCount")
        public abstract Builder tuningDatasetExampleCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningDatasetExampleCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningDatasetExampleCount() {
            return this.tuningDatasetExampleCount(Optional.empty());
        }

        @JsonProperty(value="tuningStepCount")
        public abstract Builder tuningStepCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningStepCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningStepCount() {
            return this.tuningStepCount(Optional.empty());
        }

        @JsonProperty(value="userDatasetExamples")
        public abstract Builder userDatasetExamples(List<Content> var1);

        @CanIgnoreReturnValue
        public Builder userDatasetExamples(Content ... userDatasetExamples) {
            return this.userDatasetExamples(Arrays.asList(userDatasetExamples));
        }

        @CanIgnoreReturnValue
        public Builder userDatasetExamples(Content.Builder ... userDatasetExamplesBuilders) {
            return this.userDatasetExamples((List)Arrays.asList(userDatasetExamplesBuilders).stream().map(Content.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userDatasetExamples(Optional<List<Content>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserDatasetExamples() {
            return this.userDatasetExamples(Optional.empty());
        }

        @JsonProperty(value="userInputTokenDistribution")
        public abstract Builder userInputTokenDistribution(SupervisedTuningDatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder userInputTokenDistribution(SupervisedTuningDatasetDistribution.Builder userInputTokenDistributionBuilder) {
            return this.userInputTokenDistribution(userInputTokenDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userInputTokenDistribution(Optional<SupervisedTuningDatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserInputTokenDistribution() {
            return this.userInputTokenDistribution(Optional.empty());
        }

        @JsonProperty(value="userMessagePerExampleDistribution")
        public abstract Builder userMessagePerExampleDistribution(SupervisedTuningDatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder userMessagePerExampleDistribution(SupervisedTuningDatasetDistribution.Builder userMessagePerExampleDistributionBuilder) {
            return this.userMessagePerExampleDistribution(userMessagePerExampleDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userMessagePerExampleDistribution(Optional<SupervisedTuningDatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserMessagePerExampleDistribution() {
            return this.userMessagePerExampleDistribution(Optional.empty());
        }

        @JsonProperty(value="userOutputTokenDistribution")
        public abstract Builder userOutputTokenDistribution(SupervisedTuningDatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder userOutputTokenDistribution(SupervisedTuningDatasetDistribution.Builder userOutputTokenDistributionBuilder) {
            return this.userOutputTokenDistribution(userOutputTokenDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userOutputTokenDistribution(Optional<SupervisedTuningDatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserOutputTokenDistribution() {
            return this.userOutputTokenDistribution(Optional.empty());
        }

        public abstract SupervisedTuningDataStats build();
    }
}

