/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ThinkingConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ThinkingLevel;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ThinkingConfig
extends JsonSerializable {
    @JsonProperty(value="includeThoughts")
    public abstract Optional<Boolean> includeThoughts();

    @JsonProperty(value="thinkingBudget")
    public abstract Optional<Integer> thinkingBudget();

    @JsonProperty(value="thinkingLevel")
    public abstract Optional<ThinkingLevel> thinkingLevel();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ThinkingConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ThinkingConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ThinkingConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ThinkingConfig.Builder();
        }

        @JsonProperty(value="includeThoughts")
        public abstract Builder includeThoughts(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder includeThoughts(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearIncludeThoughts() {
            return this.includeThoughts(Optional.empty());
        }

        @JsonProperty(value="thinkingBudget")
        public abstract Builder thinkingBudget(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinkingBudget(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinkingBudget() {
            return this.thinkingBudget(Optional.empty());
        }

        @JsonProperty(value="thinkingLevel")
        public abstract Builder thinkingLevel(ThinkingLevel var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinkingLevel(Optional<ThinkingLevel> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinkingLevel() {
            return this.thinkingLevel(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder thinkingLevel(ThinkingLevel.Known knownType) {
            return this.thinkingLevel(new ThinkingLevel(knownType));
        }

        @CanIgnoreReturnValue
        public Builder thinkingLevel(String thinkingLevel) {
            return this.thinkingLevel(new ThinkingLevel(thinkingLevel));
        }

        public abstract ThinkingConfig build();
    }
}

