/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Tool;
import com.google.genai.types.ComputerUse;
import com.google.genai.types.EnterpriseWebSearch;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FileSearch;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GoogleMaps;
import com.google.genai.types.GoogleSearch;
import com.google.genai.types.GoogleSearchRetrieval;
import com.google.genai.types.Retrieval;
import com.google.genai.types.ToolCodeExecution;
import com.google.genai.types.UrlContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Tool
extends JsonSerializable {
    @JsonProperty(value="functionDeclarations")
    public abstract Optional<List<FunctionDeclaration>> functionDeclarations();

    @JsonProperty(value="retrieval")
    public abstract Optional<Retrieval> retrieval();

    @JsonProperty(value="googleSearchRetrieval")
    public abstract Optional<GoogleSearchRetrieval> googleSearchRetrieval();

    @JsonIgnore
    public abstract Optional<List<Method>> functions();

    @JsonProperty(value="computerUse")
    public abstract Optional<ComputerUse> computerUse();

    @JsonProperty(value="fileSearch")
    public abstract Optional<FileSearch> fileSearch();

    @JsonProperty(value="codeExecution")
    public abstract Optional<ToolCodeExecution> codeExecution();

    @JsonProperty(value="enterpriseWebSearch")
    public abstract Optional<EnterpriseWebSearch> enterpriseWebSearch();

    @JsonProperty(value="googleMaps")
    public abstract Optional<GoogleMaps> googleMaps();

    @JsonProperty(value="googleSearch")
    public abstract Optional<GoogleSearch> googleSearch();

    @JsonProperty(value="urlContext")
    public abstract Optional<UrlContext> urlContext();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Tool.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Tool fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Tool.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Tool.Builder();
        }

        @JsonProperty(value="functionDeclarations")
        public abstract Builder functionDeclarations(List<FunctionDeclaration> var1);

        @CanIgnoreReturnValue
        public Builder functionDeclarations(FunctionDeclaration ... functionDeclarations) {
            return this.functionDeclarations(Arrays.asList(functionDeclarations));
        }

        @CanIgnoreReturnValue
        public Builder functionDeclarations(FunctionDeclaration.Builder ... functionDeclarationsBuilders) {
            return this.functionDeclarations((List)Arrays.asList(functionDeclarationsBuilders).stream().map(FunctionDeclaration.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder functionDeclarations(Optional<List<FunctionDeclaration>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFunctionDeclarations() {
            return this.functionDeclarations(Optional.empty());
        }

        @JsonProperty(value="retrieval")
        public abstract Builder retrieval(Retrieval var1);

        @CanIgnoreReturnValue
        public Builder retrieval(Retrieval.Builder retrievalBuilder) {
            return this.retrieval(retrievalBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder retrieval(Optional<Retrieval> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRetrieval() {
            return this.retrieval(Optional.empty());
        }

        @JsonProperty(value="googleSearchRetrieval")
        public abstract Builder googleSearchRetrieval(GoogleSearchRetrieval var1);

        @CanIgnoreReturnValue
        public Builder googleSearchRetrieval(GoogleSearchRetrieval.Builder googleSearchRetrievalBuilder) {
            return this.googleSearchRetrieval(googleSearchRetrievalBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder googleSearchRetrieval(Optional<GoogleSearchRetrieval> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoogleSearchRetrieval() {
            return this.googleSearchRetrieval(Optional.empty());
        }

        @JsonIgnore
        public abstract Builder functions(List<Method> var1);

        @CanIgnoreReturnValue
        public Builder functions(Method ... functions) {
            return this.functions(Arrays.asList(functions));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder functions(Optional<List<Method>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFunctions() {
            return this.functions(Optional.empty());
        }

        @JsonProperty(value="computerUse")
        public abstract Builder computerUse(ComputerUse var1);

        @CanIgnoreReturnValue
        public Builder computerUse(ComputerUse.Builder computerUseBuilder) {
            return this.computerUse(computerUseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder computerUse(Optional<ComputerUse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearComputerUse() {
            return this.computerUse(Optional.empty());
        }

        @JsonProperty(value="fileSearch")
        public abstract Builder fileSearch(FileSearch var1);

        @CanIgnoreReturnValue
        public Builder fileSearch(FileSearch.Builder fileSearchBuilder) {
            return this.fileSearch(fileSearchBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder fileSearch(Optional<FileSearch> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFileSearch() {
            return this.fileSearch(Optional.empty());
        }

        @JsonProperty(value="codeExecution")
        public abstract Builder codeExecution(ToolCodeExecution var1);

        @CanIgnoreReturnValue
        public Builder codeExecution(ToolCodeExecution.Builder codeExecutionBuilder) {
            return this.codeExecution(codeExecutionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder codeExecution(Optional<ToolCodeExecution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCodeExecution() {
            return this.codeExecution(Optional.empty());
        }

        @JsonProperty(value="enterpriseWebSearch")
        public abstract Builder enterpriseWebSearch(EnterpriseWebSearch var1);

        @CanIgnoreReturnValue
        public Builder enterpriseWebSearch(EnterpriseWebSearch.Builder enterpriseWebSearchBuilder) {
            return this.enterpriseWebSearch(enterpriseWebSearchBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enterpriseWebSearch(Optional<EnterpriseWebSearch> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnterpriseWebSearch() {
            return this.enterpriseWebSearch(Optional.empty());
        }

        @JsonProperty(value="googleMaps")
        public abstract Builder googleMaps(GoogleMaps var1);

        @CanIgnoreReturnValue
        public Builder googleMaps(GoogleMaps.Builder googleMapsBuilder) {
            return this.googleMaps(googleMapsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder googleMaps(Optional<GoogleMaps> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoogleMaps() {
            return this.googleMaps(Optional.empty());
        }

        @JsonProperty(value="googleSearch")
        public abstract Builder googleSearch(GoogleSearch var1);

        @CanIgnoreReturnValue
        public Builder googleSearch(GoogleSearch.Builder googleSearchBuilder) {
            return this.googleSearch(googleSearchBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder googleSearch(Optional<GoogleSearch> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGoogleSearch() {
            return this.googleSearch(Optional.empty());
        }

        @JsonProperty(value="urlContext")
        public abstract Builder urlContext(UrlContext var1);

        @CanIgnoreReturnValue
        public Builder urlContext(UrlContext.Builder urlContextBuilder) {
            return this.urlContext(urlContextBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder urlContext(Optional<UrlContext> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUrlContext() {
            return this.urlContext(Optional.empty());
        }

        public abstract Tool build();
    }
}

