/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TuningDataset;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TuningExample;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TuningDataset
extends JsonSerializable {
    @JsonProperty(value="gcsUri")
    public abstract Optional<String> gcsUri();

    @JsonProperty(value="vertexDatasetResource")
    public abstract Optional<String> vertexDatasetResource();

    @JsonProperty(value="examples")
    public abstract Optional<List<TuningExample>> examples();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_TuningDataset.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static TuningDataset fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TuningDataset.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TuningDataset.Builder();
        }

        @JsonProperty(value="gcsUri")
        public abstract Builder gcsUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder gcsUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGcsUri() {
            return this.gcsUri(Optional.empty());
        }

        @JsonProperty(value="vertexDatasetResource")
        public abstract Builder vertexDatasetResource(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder vertexDatasetResource(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVertexDatasetResource() {
            return this.vertexDatasetResource(Optional.empty());
        }

        @JsonProperty(value="examples")
        public abstract Builder examples(List<TuningExample> var1);

        @CanIgnoreReturnValue
        public Builder examples(TuningExample ... examples) {
            return this.examples(Arrays.asList(examples));
        }

        @CanIgnoreReturnValue
        public Builder examples(TuningExample.Builder ... examplesBuilders) {
            return this.examples((List)Arrays.asList(examplesBuilders).stream().map(TuningExample.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder examples(Optional<List<TuningExample>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExamples() {
            return this.examples(Optional.empty());
        }

        public abstract TuningDataset build();
    }
}

