/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_UpscaleImageResponse;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GeneratedImage;
import com.google.genai.types.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class UpscaleImageResponse
extends JsonSerializable {
    @JsonProperty(value="sdkHttpResponse")
    public abstract Optional<HttpResponse> sdkHttpResponse();

    @JsonProperty(value="generatedImages")
    public abstract Optional<List<GeneratedImage>> generatedImages();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_UpscaleImageResponse.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static UpscaleImageResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, UpscaleImageResponse.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_UpscaleImageResponse.Builder();
        }

        @JsonProperty(value="sdkHttpResponse")
        public abstract Builder sdkHttpResponse(HttpResponse var1);

        @CanIgnoreReturnValue
        public Builder sdkHttpResponse(HttpResponse.Builder sdkHttpResponseBuilder) {
            return this.sdkHttpResponse(sdkHttpResponseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sdkHttpResponse(Optional<HttpResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSdkHttpResponse() {
            return this.sdkHttpResponse(Optional.empty());
        }

        @JsonProperty(value="generatedImages")
        public abstract Builder generatedImages(List<GeneratedImage> var1);

        @CanIgnoreReturnValue
        public Builder generatedImages(GeneratedImage ... generatedImages) {
            return this.generatedImages(Arrays.asList(generatedImages));
        }

        @CanIgnoreReturnValue
        public Builder generatedImages(GeneratedImage.Builder ... generatedImagesBuilders) {
            return this.generatedImages((List)Arrays.asList(generatedImagesBuilders).stream().map(GeneratedImage.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder generatedImages(Optional<List<GeneratedImage>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGeneratedImages() {
            return this.generatedImages(Optional.empty());
        }

        public abstract UpscaleImageResponse build();
    }
}

