/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VideoGenerationMask;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.VideoGenerationMaskMode;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VideoGenerationMask
extends JsonSerializable {
    @JsonProperty(value="image")
    public abstract Optional<Image> image();

    @JsonProperty(value="maskMode")
    public abstract Optional<VideoGenerationMaskMode> maskMode();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VideoGenerationMask.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VideoGenerationMask fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VideoGenerationMask.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VideoGenerationMask.Builder();
        }

        @JsonProperty(value="image")
        public abstract Builder image(Image var1);

        @CanIgnoreReturnValue
        public Builder image(Image.Builder imageBuilder) {
            return this.image(imageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder image(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImage() {
            return this.image(Optional.empty());
        }

        @JsonProperty(value="maskMode")
        public abstract Builder maskMode(VideoGenerationMaskMode var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maskMode(Optional<VideoGenerationMaskMode> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaskMode() {
            return this.maskMode(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder maskMode(VideoGenerationMaskMode.Known knownType) {
            return this.maskMode(new VideoGenerationMaskMode(knownType));
        }

        @CanIgnoreReturnValue
        public Builder maskMode(String maskMode) {
            return this.maskMode(new VideoGenerationMaskMode(maskMode));
        }

        public abstract VideoGenerationMask build();
    }
}

