/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerationConfig;
import com.google.genai.types.GenerationConfigRoutingConfig;
import com.google.genai.types.GenerationConfigThinkingConfig;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.Modality;
import com.google.genai.types.ModelSelectionConfig;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerationConfig
extends JsonSerializable {
    @JsonProperty(value="modelSelectionConfig")
    public abstract Optional<ModelSelectionConfig> modelSelectionConfig();

    @JsonProperty(value="audioTimestamp")
    public abstract Optional<Boolean> audioTimestamp();

    @JsonProperty(value="candidateCount")
    public abstract Optional<Integer> candidateCount();

    @JsonProperty(value="frequencyPenalty")
    public abstract Optional<Float> frequencyPenalty();

    @JsonProperty(value="logprobs")
    public abstract Optional<Integer> logprobs();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="presencePenalty")
    public abstract Optional<Float> presencePenalty();

    @JsonProperty(value="responseLogprobs")
    public abstract Optional<Boolean> responseLogprobs();

    @JsonProperty(value="responseMimeType")
    public abstract Optional<String> responseMimeType();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<Modality>> responseModalities();

    @JsonProperty(value="responseSchema")
    public abstract Optional<Schema> responseSchema();

    @JsonProperty(value="responseJsonSchema")
    public abstract Optional<Object> responseJsonSchema();

    @JsonProperty(value="routingConfig")
    public abstract Optional<GenerationConfigRoutingConfig> routingConfig();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="stopSequences")
    public abstract Optional<List<String>> stopSequences();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="thinkingConfig")
    public abstract Optional<GenerationConfigThinkingConfig> thinkingConfig();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    public static Builder builder() {
        return new AutoValue_GenerationConfig.Builder();
    }

    public abstract Builder toBuilder();

    public static GenerationConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerationConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerationConfig.Builder();
        }

        @JsonProperty(value="modelSelectionConfig")
        public abstract Builder modelSelectionConfig(ModelSelectionConfig var1);

        public Builder modelSelectionConfig(ModelSelectionConfig.Builder modelSelectionConfigBuilder) {
            return this.modelSelectionConfig(modelSelectionConfigBuilder.build());
        }

        @JsonProperty(value="audioTimestamp")
        public abstract Builder audioTimestamp(boolean var1);

        @JsonProperty(value="candidateCount")
        public abstract Builder candidateCount(Integer var1);

        @JsonProperty(value="frequencyPenalty")
        public abstract Builder frequencyPenalty(Float var1);

        @JsonProperty(value="logprobs")
        public abstract Builder logprobs(Integer var1);

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="presencePenalty")
        public abstract Builder presencePenalty(Float var1);

        @JsonProperty(value="responseLogprobs")
        public abstract Builder responseLogprobs(boolean var1);

        @JsonProperty(value="responseMimeType")
        public abstract Builder responseMimeType(String var1);

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<Modality> var1);

        public Builder responseModalities(Modality ... responseModalities) {
            return this.responseModalities(Arrays.asList(responseModalities));
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(String ... responseModalities) {
            return this.responseModalitiesFromString(Arrays.asList(responseModalities));
        }

        @CanIgnoreReturnValue
        public Builder responseModalities(Modality.Known ... knownTypes) {
            return this.responseModalitiesFromKnown(Arrays.asList(knownTypes));
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromKnown(List<Modality.Known> knownTypes) {
            ImmutableList listItems = (ImmutableList)knownTypes.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromString(List<String> responseModalities) {
            ImmutableList listItems = (ImmutableList)responseModalities.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities((List<Modality>)listItems);
        }

        @JsonProperty(value="responseSchema")
        public abstract Builder responseSchema(Schema var1);

        public Builder responseSchema(Schema.Builder responseSchemaBuilder) {
            return this.responseSchema(responseSchemaBuilder.build());
        }

        @JsonProperty(value="responseJsonSchema")
        public abstract Builder responseJsonSchema(Object var1);

        @JsonProperty(value="routingConfig")
        public abstract Builder routingConfig(GenerationConfigRoutingConfig var1);

        public Builder routingConfig(GenerationConfigRoutingConfig.Builder routingConfigBuilder) {
            return this.routingConfig(routingConfigBuilder.build());
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        public Builder speechConfig(SpeechConfig.Builder speechConfigBuilder) {
            return this.speechConfig(speechConfigBuilder.build());
        }

        @JsonProperty(value="stopSequences")
        public abstract Builder stopSequences(List<String> var1);

        public Builder stopSequences(String ... stopSequences) {
            return this.stopSequences(Arrays.asList(stopSequences));
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @JsonProperty(value="thinkingConfig")
        public abstract Builder thinkingConfig(GenerationConfigThinkingConfig var1);

        public Builder thinkingConfig(GenerationConfigThinkingConfig.Builder thinkingConfigBuilder) {
            return this.thinkingConfig(thinkingConfigBuilder.build());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        public abstract GenerationConfig build();
    }
}

