/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CachedContent;
import com.google.genai.types.CreateCachedContentConfig;
import com.google.genai.types.CreateCachedContentParameters;
import com.google.genai.types.DeleteCachedContentConfig;
import com.google.genai.types.DeleteCachedContentParameters;
import com.google.genai.types.DeleteCachedContentResponse;
import com.google.genai.types.GetCachedContentConfig;
import com.google.genai.types.GetCachedContentParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ListCachedContentsConfig;
import com.google.genai.types.ListCachedContentsParameters;
import com.google.genai.types.ListCachedContentsResponse;
import com.google.genai.types.UpdateCachedContentConfig;
import com.google.genai.types.UpdateCachedContentParameters;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public final class Caches {
    final ApiClient apiClient;

    public Caches(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"behavior"}) != null) {
            Common.setValueByPath(toObject, new String[]{"behavior"}, Common.getValueByPath(fromObject, new String[]{"behavior"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"apiKeyString"}))) {
            throw new IllegalArgumentException("apiKeyString parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"}))) {
            throw new IllegalArgumentException("apiKeyConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"authConfig"}))) {
            throw new IllegalArgumentException("authConfig parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"retrieval"}))) {
            throw new IllegalArgumentException("retrieval parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}))) {
            throw new IllegalArgumentException("enterpriseWebSearch parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"googleMaps"}))) {
            throw new IllegalArgumentException("googleMaps parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"tools"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, this.toolConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"toolConfig"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}))) {
            throw new IllegalArgumentException("kmsKeyName parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tCachesModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.createCachedContentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.updateCachedContentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.listCachedContentsConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"behavior"}))) {
            throw new IllegalArgumentException("behavior parameter is not supported in Vertex AI.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyString"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyString"}, Common.getValueByPath(fromObject, new String[]{"apiKeyString"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyConfig"}, this.apiKeyConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"authConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authConfig"}, this.authConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"authConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrieval"}, Common.getValueByPath(fromObject, new String[]{"retrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enterpriseWebSearch"}, this.enterpriseWebSearchToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToVertex(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"tools"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, this.toolConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"toolConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"encryption_spec", "kmsKeyName"}, Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tCachesModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.createCachedContentConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.updateCachedContentConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.listCachedContentsConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cachedContentFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContents"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"cachedContents"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.cachedContentFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"cachedContents"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cachedContentFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContents"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"cachedContents"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.cachedContentFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"cachedContents"}, result);
        }
        return toObject;
    }

    public CachedContent create(String model, CreateCachedContentConfig config) {
        String path;
        ObjectNode body;
        CreateCachedContentParameters.Builder parameterBuilder = CreateCachedContentParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.createCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("cachedContents", body.get("_url"));
        } else {
            body = this.createCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("cachedContents", body.get("_url")) : "cachedContents";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("post", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.cachedContentFromVertex(responseNode, null) : this.cachedContentFromMldev(responseNode, null);
            CachedContent cachedContent = JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
            return cachedContent;
        }
    }

    public CachedContent get(String name, GetCachedContentConfig config) {
        String path;
        ObjectNode body;
        GetCachedContentParameters.Builder parameterBuilder = GetCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.getCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("get", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.cachedContentFromVertex(responseNode, null) : this.cachedContentFromMldev(responseNode, null);
            CachedContent cachedContent = JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
            return cachedContent;
        }
    }

    public DeleteCachedContentResponse delete(String name, DeleteCachedContentConfig config) {
        String path;
        ObjectNode body;
        DeleteCachedContentParameters.Builder parameterBuilder = DeleteCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.deleteCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.deleteCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("delete", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.deleteCachedContentResponseFromVertex(responseNode, null) : this.deleteCachedContentResponseFromMldev(responseNode, null);
            DeleteCachedContentResponse deleteCachedContentResponse = JsonSerializable.fromJsonNode(responseNode, DeleteCachedContentResponse.class);
            return deleteCachedContentResponse;
        }
    }

    public CachedContent update(String name, UpdateCachedContentConfig config) {
        String path;
        ObjectNode body;
        UpdateCachedContentParameters.Builder parameterBuilder = UpdateCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.updateCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.updateCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("patch", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.cachedContentFromVertex(responseNode, null) : this.cachedContentFromMldev(responseNode, null);
            CachedContent cachedContent = JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
            return cachedContent;
        }
    }

    ListCachedContentsResponse privateList(ListCachedContentsConfig config) {
        String path;
        ObjectNode body;
        ListCachedContentsParameters.Builder parameterBuilder = ListCachedContentsParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.listCachedContentsParametersToVertex(parameterNode, null);
            path = Common.formatMap("cachedContents", body.get("_url"));
        } else {
            body = this.listCachedContentsParametersToMldev(parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("cachedContents", body.get("_url")) : "cachedContents";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("get", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.listCachedContentsResponseFromVertex(responseNode, null) : this.listCachedContentsResponseFromMldev(responseNode, null);
            ListCachedContentsResponse listCachedContentsResponse = JsonSerializable.fromJsonNode(responseNode, ListCachedContentsResponse.class);
            return listCachedContentsResponse;
        }
    }

    public Pager<CachedContent> list(ListCachedContentsConfig config) {
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListCachedContentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListCachedContentsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListCachedContentsConfig)requestConfig);
        };
        return new Pager<CachedContent>(BasePager.PagedItem.CACHED_CONTENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }
}

