/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Tool;
import com.google.genai.types.EnterpriseWebSearch;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GoogleMaps;
import com.google.genai.types.GoogleSearch;
import com.google.genai.types.GoogleSearchRetrieval;
import com.google.genai.types.Retrieval;
import com.google.genai.types.ToolCodeExecution;
import com.google.genai.types.UrlContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Tool
extends JsonSerializable {
    @JsonProperty(value="functionDeclarations")
    public abstract Optional<List<FunctionDeclaration>> functionDeclarations();

    @JsonProperty(value="retrieval")
    public abstract Optional<Retrieval> retrieval();

    @JsonProperty(value="googleSearch")
    public abstract Optional<GoogleSearch> googleSearch();

    @JsonProperty(value="googleSearchRetrieval")
    public abstract Optional<GoogleSearchRetrieval> googleSearchRetrieval();

    @JsonProperty(value="enterpriseWebSearch")
    public abstract Optional<EnterpriseWebSearch> enterpriseWebSearch();

    @JsonProperty(value="googleMaps")
    public abstract Optional<GoogleMaps> googleMaps();

    @JsonProperty(value="urlContext")
    public abstract Optional<UrlContext> urlContext();

    @JsonIgnore
    public abstract Optional<List<Method>> functions();

    @JsonProperty(value="codeExecution")
    public abstract Optional<ToolCodeExecution> codeExecution();

    public static Builder builder() {
        return new AutoValue_Tool.Builder();
    }

    public abstract Builder toBuilder();

    public static Tool fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Tool.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Tool.Builder();
        }

        @JsonProperty(value="functionDeclarations")
        public abstract Builder functionDeclarations(List<FunctionDeclaration> var1);

        public Builder functionDeclarations(FunctionDeclaration ... functionDeclarations) {
            return this.functionDeclarations(Arrays.asList(functionDeclarations));
        }

        public Builder functionDeclarations(FunctionDeclaration.Builder ... functionDeclarationsBuilders) {
            return this.functionDeclarations((List)Arrays.asList(functionDeclarationsBuilders).stream().map(FunctionDeclaration.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="retrieval")
        public abstract Builder retrieval(Retrieval var1);

        public Builder retrieval(Retrieval.Builder retrievalBuilder) {
            return this.retrieval(retrievalBuilder.build());
        }

        @JsonProperty(value="googleSearch")
        public abstract Builder googleSearch(GoogleSearch var1);

        public Builder googleSearch(GoogleSearch.Builder googleSearchBuilder) {
            return this.googleSearch(googleSearchBuilder.build());
        }

        @JsonProperty(value="googleSearchRetrieval")
        public abstract Builder googleSearchRetrieval(GoogleSearchRetrieval var1);

        public Builder googleSearchRetrieval(GoogleSearchRetrieval.Builder googleSearchRetrievalBuilder) {
            return this.googleSearchRetrieval(googleSearchRetrievalBuilder.build());
        }

        @JsonProperty(value="enterpriseWebSearch")
        public abstract Builder enterpriseWebSearch(EnterpriseWebSearch var1);

        public Builder enterpriseWebSearch(EnterpriseWebSearch.Builder enterpriseWebSearchBuilder) {
            return this.enterpriseWebSearch(enterpriseWebSearchBuilder.build());
        }

        @JsonProperty(value="googleMaps")
        public abstract Builder googleMaps(GoogleMaps var1);

        public Builder googleMaps(GoogleMaps.Builder googleMapsBuilder) {
            return this.googleMaps(googleMapsBuilder.build());
        }

        @JsonProperty(value="urlContext")
        public abstract Builder urlContext(UrlContext var1);

        public Builder urlContext(UrlContext.Builder urlContextBuilder) {
            return this.urlContext(urlContextBuilder.build());
        }

        @JsonIgnore
        public abstract Builder functions(List<Method> var1);

        public Builder functions(Method ... functions) {
            return this.functions(Arrays.asList(functions));
        }

        @JsonProperty(value="codeExecution")
        public abstract Builder codeExecution(ToolCodeExecution var1);

        public Builder codeExecution(ToolCodeExecution.Builder codeExecutionBuilder) {
            return this.codeExecution(codeExecutionBuilder.build());
        }

        public abstract Tool build();
    }
}

