/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Optional;

/** Tool to support Google Maps in Model. */
@AutoValue
@JsonDeserialize(builder = GoogleMaps.Builder.class)
public abstract class GoogleMaps extends JsonSerializable {
  /** Optional. Auth config for the Google Maps tool. */
  @JsonProperty("authConfig")
  public abstract Optional<AuthConfig> authConfig();

  /** Instantiates a builder for GoogleMaps. */
  public static Builder builder() {
    return new AutoValue_GoogleMaps.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for GoogleMaps. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `GoogleMaps.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_GoogleMaps.Builder();
    }

    /**
     * Setter for authConfig.
     *
     * <p>authConfig: Optional. Auth config for the Google Maps tool.
     */
    @JsonProperty("authConfig")
    public abstract Builder authConfig(AuthConfig authConfig);

    /**
     * Setter for authConfig builder.
     *
     * <p>authConfig: Optional. Auth config for the Google Maps tool.
     */
    public Builder authConfig(AuthConfig.Builder authConfigBuilder) {
      return authConfig(authConfigBuilder.build());
    }

    public abstract GoogleMaps build();
  }

  /** Deserializes a JSON string to a GoogleMaps object. */
  public static GoogleMaps fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, GoogleMaps.class);
  }
}
