/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import static com.google.common.collect.ImmutableList.toImmutableList;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * Request for the client to execute the `function_calls` and return the responses with the matching
 * `id`s.
 */
@AutoValue
@JsonDeserialize(builder = LiveServerToolCall.Builder.class)
public abstract class LiveServerToolCall extends JsonSerializable {
  /** The function call to be executed. */
  @JsonProperty("functionCalls")
  public abstract Optional<List<FunctionCall>> functionCalls();

  /** Instantiates a builder for LiveServerToolCall. */
  public static Builder builder() {
    return new AutoValue_LiveServerToolCall.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for LiveServerToolCall. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `LiveServerToolCall.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_LiveServerToolCall.Builder();
    }

    /**
     * Setter for functionCalls.
     *
     * <p>functionCalls: The function call to be executed.
     */
    @JsonProperty("functionCalls")
    public abstract Builder functionCalls(List<FunctionCall> functionCalls);

    /**
     * Setter for functionCalls.
     *
     * <p>functionCalls: The function call to be executed.
     */
    public Builder functionCalls(FunctionCall... functionCalls) {
      return functionCalls(Arrays.asList(functionCalls));
    }

    /**
     * Setter for functionCalls builder.
     *
     * <p>functionCalls: The function call to be executed.
     */
    public Builder functionCalls(FunctionCall.Builder... functionCallsBuilders) {
      return functionCalls(
          Arrays.asList(functionCallsBuilders).stream()
              .map(FunctionCall.Builder::build)
              .collect(toImmutableList()));
    }

    public abstract LiveServerToolCall build();
  }

  /** Deserializes a JSON string to a LiveServerToolCall object. */
  public static LiveServerToolCall fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, LiveServerToolCall.class);
  }
}
