package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Tool extends Tool {

  private final Optional<List<FunctionDeclaration>> functionDeclarations;

  private final Optional<Retrieval> retrieval;

  private final Optional<GoogleSearch> googleSearch;

  private final Optional<GoogleSearchRetrieval> googleSearchRetrieval;

  private final Optional<EnterpriseWebSearch> enterpriseWebSearch;

  private final Optional<GoogleMaps> googleMaps;

  private final Optional<UrlContext> urlContext;

  private final Optional<List<Method>> functions;

  private final Optional<ToolCodeExecution> codeExecution;

  private final Optional<ToolComputerUse> computerUse;

  private AutoValue_Tool(
      Optional<List<FunctionDeclaration>> functionDeclarations,
      Optional<Retrieval> retrieval,
      Optional<GoogleSearch> googleSearch,
      Optional<GoogleSearchRetrieval> googleSearchRetrieval,
      Optional<EnterpriseWebSearch> enterpriseWebSearch,
      Optional<GoogleMaps> googleMaps,
      Optional<UrlContext> urlContext,
      Optional<List<Method>> functions,
      Optional<ToolCodeExecution> codeExecution,
      Optional<ToolComputerUse> computerUse) {
    this.functionDeclarations = functionDeclarations;
    this.retrieval = retrieval;
    this.googleSearch = googleSearch;
    this.googleSearchRetrieval = googleSearchRetrieval;
    this.enterpriseWebSearch = enterpriseWebSearch;
    this.googleMaps = googleMaps;
    this.urlContext = urlContext;
    this.functions = functions;
    this.codeExecution = codeExecution;
    this.computerUse = computerUse;
  }

  @JsonProperty("functionDeclarations")
  @Override
  public Optional<List<FunctionDeclaration>> functionDeclarations() {
    return functionDeclarations;
  }

  @JsonProperty("retrieval")
  @Override
  public Optional<Retrieval> retrieval() {
    return retrieval;
  }

  @JsonProperty("googleSearch")
  @Override
  public Optional<GoogleSearch> googleSearch() {
    return googleSearch;
  }

  @JsonProperty("googleSearchRetrieval")
  @Override
  public Optional<GoogleSearchRetrieval> googleSearchRetrieval() {
    return googleSearchRetrieval;
  }

  @JsonProperty("enterpriseWebSearch")
  @Override
  public Optional<EnterpriseWebSearch> enterpriseWebSearch() {
    return enterpriseWebSearch;
  }

  @JsonProperty("googleMaps")
  @Override
  public Optional<GoogleMaps> googleMaps() {
    return googleMaps;
  }

  @JsonProperty("urlContext")
  @Override
  public Optional<UrlContext> urlContext() {
    return urlContext;
  }

  @JsonIgnore
  @Override
  public Optional<List<Method>> functions() {
    return functions;
  }

  @JsonProperty("codeExecution")
  @Override
  public Optional<ToolCodeExecution> codeExecution() {
    return codeExecution;
  }

  @JsonProperty("computerUse")
  @Override
  public Optional<ToolComputerUse> computerUse() {
    return computerUse;
  }

  @Override
  public String toString() {
    return "Tool{"
        + "functionDeclarations=" + functionDeclarations + ", "
        + "retrieval=" + retrieval + ", "
        + "googleSearch=" + googleSearch + ", "
        + "googleSearchRetrieval=" + googleSearchRetrieval + ", "
        + "enterpriseWebSearch=" + enterpriseWebSearch + ", "
        + "googleMaps=" + googleMaps + ", "
        + "urlContext=" + urlContext + ", "
        + "functions=" + functions + ", "
        + "codeExecution=" + codeExecution + ", "
        + "computerUse=" + computerUse
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Tool) {
      Tool that = (Tool) o;
      return this.functionDeclarations.equals(that.functionDeclarations())
          && this.retrieval.equals(that.retrieval())
          && this.googleSearch.equals(that.googleSearch())
          && this.googleSearchRetrieval.equals(that.googleSearchRetrieval())
          && this.enterpriseWebSearch.equals(that.enterpriseWebSearch())
          && this.googleMaps.equals(that.googleMaps())
          && this.urlContext.equals(that.urlContext())
          && this.functions.equals(that.functions())
          && this.codeExecution.equals(that.codeExecution())
          && this.computerUse.equals(that.computerUse());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= functionDeclarations.hashCode();
    h$ *= 1000003;
    h$ ^= retrieval.hashCode();
    h$ *= 1000003;
    h$ ^= googleSearch.hashCode();
    h$ *= 1000003;
    h$ ^= googleSearchRetrieval.hashCode();
    h$ *= 1000003;
    h$ ^= enterpriseWebSearch.hashCode();
    h$ *= 1000003;
    h$ ^= googleMaps.hashCode();
    h$ *= 1000003;
    h$ ^= urlContext.hashCode();
    h$ *= 1000003;
    h$ ^= functions.hashCode();
    h$ *= 1000003;
    h$ ^= codeExecution.hashCode();
    h$ *= 1000003;
    h$ ^= computerUse.hashCode();
    return h$;
  }

  @Override
  public Tool.Builder toBuilder() {
    return new AutoValue_Tool.Builder(this);
  }

  static final class Builder extends Tool.Builder {
    private Optional<List<FunctionDeclaration>> functionDeclarations = Optional.empty();
    private Optional<Retrieval> retrieval = Optional.empty();
    private Optional<GoogleSearch> googleSearch = Optional.empty();
    private Optional<GoogleSearchRetrieval> googleSearchRetrieval = Optional.empty();
    private Optional<EnterpriseWebSearch> enterpriseWebSearch = Optional.empty();
    private Optional<GoogleMaps> googleMaps = Optional.empty();
    private Optional<UrlContext> urlContext = Optional.empty();
    private Optional<List<Method>> functions = Optional.empty();
    private Optional<ToolCodeExecution> codeExecution = Optional.empty();
    private Optional<ToolComputerUse> computerUse = Optional.empty();
    Builder() {
    }
    Builder(Tool source) {
      this.functionDeclarations = source.functionDeclarations();
      this.retrieval = source.retrieval();
      this.googleSearch = source.googleSearch();
      this.googleSearchRetrieval = source.googleSearchRetrieval();
      this.enterpriseWebSearch = source.enterpriseWebSearch();
      this.googleMaps = source.googleMaps();
      this.urlContext = source.urlContext();
      this.functions = source.functions();
      this.codeExecution = source.codeExecution();
      this.computerUse = source.computerUse();
    }
    @Override
    public Tool.Builder functionDeclarations(List<FunctionDeclaration> functionDeclarations) {
      this.functionDeclarations = Optional.of(functionDeclarations);
      return this;
    }
    @Override
    public Tool.Builder retrieval(Retrieval retrieval) {
      this.retrieval = Optional.of(retrieval);
      return this;
    }
    @Override
    public Tool.Builder googleSearch(GoogleSearch googleSearch) {
      this.googleSearch = Optional.of(googleSearch);
      return this;
    }
    @Override
    public Tool.Builder googleSearchRetrieval(GoogleSearchRetrieval googleSearchRetrieval) {
      this.googleSearchRetrieval = Optional.of(googleSearchRetrieval);
      return this;
    }
    @Override
    public Tool.Builder enterpriseWebSearch(EnterpriseWebSearch enterpriseWebSearch) {
      this.enterpriseWebSearch = Optional.of(enterpriseWebSearch);
      return this;
    }
    @Override
    public Tool.Builder googleMaps(GoogleMaps googleMaps) {
      this.googleMaps = Optional.of(googleMaps);
      return this;
    }
    @Override
    public Tool.Builder urlContext(UrlContext urlContext) {
      this.urlContext = Optional.of(urlContext);
      return this;
    }
    @Override
    public Tool.Builder functions(List<Method> functions) {
      this.functions = Optional.of(functions);
      return this;
    }
    @Override
    public Tool.Builder codeExecution(ToolCodeExecution codeExecution) {
      this.codeExecution = Optional.of(codeExecution);
      return this;
    }
    @Override
    public Tool.Builder computerUse(ToolComputerUse computerUse) {
      this.computerUse = Optional.of(computerUse);
      return this;
    }
    @Override
    public Tool build() {
      return new AutoValue_Tool(
          this.functionDeclarations,
          this.retrieval,
          this.googleSearch,
          this.googleSearchRetrieval,
          this.enterpriseWebSearch,
          this.googleMaps,
          this.urlContext,
          this.functions,
          this.codeExecution,
          this.computerUse);
    }
  }

}
