/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Optional;

/** The search parameters to use for the ELASTIC_SEARCH spec. */
@AutoValue
@JsonDeserialize(builder = ExternalApiElasticSearchParams.Builder.class)
public abstract class ExternalApiElasticSearchParams extends JsonSerializable {
  /** The ElasticSearch index to use. */
  @JsonProperty("index")
  public abstract Optional<String> index();

  /**
   * Optional. Number of hits (chunks) to request. When specified, it is passed to Elasticsearch as
   * the `num_hits` param.
   */
  @JsonProperty("numHits")
  public abstract Optional<Integer> numHits();

  /** The ElasticSearch search template to use. */
  @JsonProperty("searchTemplate")
  public abstract Optional<String> searchTemplate();

  /** Instantiates a builder for ExternalApiElasticSearchParams. */
  public static Builder builder() {
    return new AutoValue_ExternalApiElasticSearchParams.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for ExternalApiElasticSearchParams. */
  @AutoValue.Builder
  public abstract static class Builder {
    /**
     * For internal usage. Please use `ExternalApiElasticSearchParams.builder()` for instantiation.
     */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_ExternalApiElasticSearchParams.Builder();
    }

    /**
     * Setter for index.
     *
     * <p>index: The ElasticSearch index to use.
     */
    @JsonProperty("index")
    public abstract Builder index(String index);

    /**
     * Setter for numHits.
     *
     * <p>numHits: Optional. Number of hits (chunks) to request. When specified, it is passed to
     * Elasticsearch as the `num_hits` param.
     */
    @JsonProperty("numHits")
    public abstract Builder numHits(Integer numHits);

    /**
     * Setter for searchTemplate.
     *
     * <p>searchTemplate: The ElasticSearch search template to use.
     */
    @JsonProperty("searchTemplate")
    public abstract Builder searchTemplate(String searchTemplate);

    public abstract ExternalApiElasticSearchParams build();
  }

  /** Deserializes a JSON string to a ExternalApiElasticSearchParams object. */
  public static ExternalApiElasticSearchParams fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, ExternalApiElasticSearchParams.class);
  }
}
