/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Optional;

/** Response message for API call. */
@AutoValue
@JsonDeserialize(builder = LiveServerMessage.Builder.class)
public abstract class LiveServerMessage extends JsonSerializable {
  /** Sent in response to a `LiveClientSetup` message from the client. */
  @JsonProperty("setupComplete")
  public abstract Optional<LiveServerSetupComplete> setupComplete();

  /** Content generated by the model in response to client messages. */
  @JsonProperty("serverContent")
  public abstract Optional<LiveServerContent> serverContent();

  /**
   * Request for the client to execute the `function_calls` and return the responses with the
   * matching `id`s.
   */
  @JsonProperty("toolCall")
  public abstract Optional<LiveServerToolCall> toolCall();

  /**
   * Notification for the client that a previously issued `ToolCallMessage` with the specified `id`s
   * should have been not executed and should be cancelled.
   */
  @JsonProperty("toolCallCancellation")
  public abstract Optional<LiveServerToolCallCancellation> toolCallCancellation();

  /** Usage metadata about model response(s). */
  @JsonProperty("usageMetadata")
  public abstract Optional<UsageMetadata> usageMetadata();

  /** Server will disconnect soon. */
  @JsonProperty("goAway")
  public abstract Optional<LiveServerGoAway> goAway();

  /** Update of the session resumption state. */
  @JsonProperty("sessionResumptionUpdate")
  public abstract Optional<LiveServerSessionResumptionUpdate> sessionResumptionUpdate();

  /** Instantiates a builder for LiveServerMessage. */
  public static Builder builder() {
    return new AutoValue_LiveServerMessage.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for LiveServerMessage. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `LiveServerMessage.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_LiveServerMessage.Builder();
    }

    /**
     * Setter for setupComplete.
     *
     * <p>setupComplete: Sent in response to a `LiveClientSetup` message from the client.
     */
    @JsonProperty("setupComplete")
    public abstract Builder setupComplete(LiveServerSetupComplete setupComplete);

    /**
     * Setter for setupComplete builder.
     *
     * <p>setupComplete: Sent in response to a `LiveClientSetup` message from the client.
     */
    public Builder setupComplete(LiveServerSetupComplete.Builder setupCompleteBuilder) {
      return setupComplete(setupCompleteBuilder.build());
    }

    /**
     * Setter for serverContent.
     *
     * <p>serverContent: Content generated by the model in response to client messages.
     */
    @JsonProperty("serverContent")
    public abstract Builder serverContent(LiveServerContent serverContent);

    /**
     * Setter for serverContent builder.
     *
     * <p>serverContent: Content generated by the model in response to client messages.
     */
    public Builder serverContent(LiveServerContent.Builder serverContentBuilder) {
      return serverContent(serverContentBuilder.build());
    }

    /**
     * Setter for toolCall.
     *
     * <p>toolCall: Request for the client to execute the `function_calls` and return the responses
     * with the matching `id`s.
     */
    @JsonProperty("toolCall")
    public abstract Builder toolCall(LiveServerToolCall toolCall);

    /**
     * Setter for toolCall builder.
     *
     * <p>toolCall: Request for the client to execute the `function_calls` and return the responses
     * with the matching `id`s.
     */
    public Builder toolCall(LiveServerToolCall.Builder toolCallBuilder) {
      return toolCall(toolCallBuilder.build());
    }

    /**
     * Setter for toolCallCancellation.
     *
     * <p>toolCallCancellation: Notification for the client that a previously issued
     * `ToolCallMessage` with the specified `id`s should have been not executed and should be
     * cancelled.
     */
    @JsonProperty("toolCallCancellation")
    public abstract Builder toolCallCancellation(
        LiveServerToolCallCancellation toolCallCancellation);

    /**
     * Setter for toolCallCancellation builder.
     *
     * <p>toolCallCancellation: Notification for the client that a previously issued
     * `ToolCallMessage` with the specified `id`s should have been not executed and should be
     * cancelled.
     */
    public Builder toolCallCancellation(
        LiveServerToolCallCancellation.Builder toolCallCancellationBuilder) {
      return toolCallCancellation(toolCallCancellationBuilder.build());
    }

    /**
     * Setter for usageMetadata.
     *
     * <p>usageMetadata: Usage metadata about model response(s).
     */
    @JsonProperty("usageMetadata")
    public abstract Builder usageMetadata(UsageMetadata usageMetadata);

    /**
     * Setter for usageMetadata builder.
     *
     * <p>usageMetadata: Usage metadata about model response(s).
     */
    public Builder usageMetadata(UsageMetadata.Builder usageMetadataBuilder) {
      return usageMetadata(usageMetadataBuilder.build());
    }

    /**
     * Setter for goAway.
     *
     * <p>goAway: Server will disconnect soon.
     */
    @JsonProperty("goAway")
    public abstract Builder goAway(LiveServerGoAway goAway);

    /**
     * Setter for goAway builder.
     *
     * <p>goAway: Server will disconnect soon.
     */
    public Builder goAway(LiveServerGoAway.Builder goAwayBuilder) {
      return goAway(goAwayBuilder.build());
    }

    /**
     * Setter for sessionResumptionUpdate.
     *
     * <p>sessionResumptionUpdate: Update of the session resumption state.
     */
    @JsonProperty("sessionResumptionUpdate")
    public abstract Builder sessionResumptionUpdate(
        LiveServerSessionResumptionUpdate sessionResumptionUpdate);

    /**
     * Setter for sessionResumptionUpdate builder.
     *
     * <p>sessionResumptionUpdate: Update of the session resumption state.
     */
    public Builder sessionResumptionUpdate(
        LiveServerSessionResumptionUpdate.Builder sessionResumptionUpdateBuilder) {
      return sessionResumptionUpdate(sessionResumptionUpdateBuilder.build());
    }

    public abstract LiveServerMessage build();
  }

  /** Deserializes a JSON string to a LiveServerMessage object. */
  public static LiveServerMessage fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, LiveServerMessage.class);
  }
}
