/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.ReplayApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.ClientOptions;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ReplayFile;
import com.google.genai.types.ReplayInteraction;
import com.google.genai.types.ReplayRequest;
import com.google.genai.types.ReplayResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

@ExcludeFromGeneratedCoverageReport
final class ReplayApiClient
extends ApiClient {
    private final String clientMode;
    private final String replaysDirectory;
    private String replayId;
    private int replayInteractionIndex;
    private List<ReplayInteraction> replayInteractions;

    ReplayApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions, Optional<ClientOptions> clientOptions, String replaysDirectory, String replayId, String clientMode) {
        super(apiKey, httpOptions, clientOptions);
        Preconditions.checkNotNull((Object)replaysDirectory, (Object)"replaysDirectory cannot be null");
        Preconditions.checkNotNull((Object)replayId, (Object)"replayId cannot be null");
        Preconditions.checkNotNull((Object)clientMode, (Object)"clientMode cannot be null");
        this.replaysDirectory = replaysDirectory;
        this.replayId = replayId;
        this.clientMode = clientMode;
    }

    ReplayApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions, Optional<ClientOptions> clientOptions, String replaysDirectory, String replayId, String clientMode) {
        super(project, location, credentials, httpOptions, clientOptions);
        Preconditions.checkNotNull((Object)replaysDirectory, (Object)"replaysDirectory cannot be null");
        Preconditions.checkNotNull((Object)replayId, (Object)"replayId cannot be null");
        Preconditions.checkNotNull((Object)clientMode, (Object)"clientMode cannot be null");
        this.replaysDirectory = replaysDirectory;
        this.replayId = replayId;
        this.clientMode = clientMode;
    }

    static String readString(Path path) {
        String string;
        block8: {
            Stream<String> stream = Files.lines(path);
            try {
                string = stream.collect(Collectors.joining(System.lineSeparator()));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GenAiIOException("Failed to read replay file from path: " + path.toString(), e);
                }
            }
            stream.close();
        }
        return string;
    }

    void initializeReplaySession(String replayId) {
        this.replayId = replayId;
        String replayPath = this.replaysDirectory + "/" + this.replayId;
        String replayData = ReplayApiClient.readString(Paths.get(replayPath, new String[0]));
        this.replayInteractions = ReplayFile.fromJson(replayData).interactions().orElseThrow(() -> new GenAiIOException(String.format("The replay file %s does not have interactions.", replayPath)));
        this.replayInteractionIndex = 0;
    }

    @Override
    public ApiResponse request(String httpMethod, String path, String requestJson, Optional<HttpOptions> httpOptions) {
        if (this.clientMode.equals("replay")) {
            ReplayInteraction currentInteraction = this.replayInteractions.get(this.replayInteractionIndex);
            ++this.replayInteractionIndex;
            this.matchRequest(currentInteraction.request().orElse(null), this.buildRequest(httpMethod, path, requestJson, httpOptions));
            return this.buildResponseFromReplay(currentInteraction.response().orElse(null));
        }
        throw new IllegalArgumentException("Invalid client mode: " + this.clientMode);
    }

    @Override
    public ApiResponse request(String httpMethod, String path, byte[] requestBytes, Optional<HttpOptions> httpOptions) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private void matchRequest(ReplayRequest replayRequest, Request actualRequest) {
        String actualPath;
        String actualMethod;
        if (replayRequest == null) {
            throw new IllegalArgumentException("Replay request is null.");
        }
        String replayMethod = replayRequest.method().orElse("").toLowerCase(Locale.ROOT);
        if (!ReplayApiClient.equalsIgnoreKeyCase(replayMethod, actualMethod = actualRequest.method().toLowerCase(Locale.ROOT))) {
            throw new AssertionError((Object)String.format("Request method mismatch:\nReplay: %s\nActual: %s", replayMethod, actualMethod));
        }
        String replayPath = replayRequest.url().orElse("");
        if (!ReplayApiClient.equalsIgnoreKeyCase(replayPath, actualPath = ReplayApiClient.redactRequestUrl(actualRequest.url().toString()))) {
            throw new AssertionError((Object)String.format("Request url mismatch:\nReplay: %s\nActual: %s", replayPath, actualPath));
        }
        Map<String, String> replayHeaders = replayRequest.headers().orElse((Map<String, String>)ImmutableMap.of());
        Map<String, String> actualHeaders = new HashMap<String, String>();
        Map headersMap = actualRequest.headers().toMultimap();
        for (Map.Entry entry : headersMap.entrySet()) {
            actualHeaders.put((String)entry.getKey(), String.join((CharSequence)" ", (Iterable)entry.getValue()));
        }
        if (!ReplayApiClient.equalsIgnoreKeyCase(replayHeaders, actualHeaders = ReplayApiClient.redactRequestHeaders(actualHeaders))) {
            throw new AssertionError((Object)String.format("Request headers mismatch:\nReplay: %s\nActual: %s", replayHeaders, actualHeaders));
        }
        if (actualMethod.equals("get") || actualMethod.equals("delete")) {
            return;
        }
        JsonNode actualBody = ReplayApiClient.redactRequestBody(JsonSerializable.stringToJsonNode(ReplayApiClient.requestBodyToString(actualRequest.body())));
        JsonNode replayBody = JsonSerializable.toJsonNode(((List)replayRequest.bodySegments().orElse(new ArrayList())).get(0));
        if (!ReplayApiClient.equalsIgnoreKeyCase(replayBody, actualBody)) {
            throw new AssertionError((Object)String.format("Request body mismatch:\nReplay: %s\nActual: %s", replayBody, actualBody));
        }
    }

    private ReplayApiResponse buildResponseFromReplay(ReplayResponse replayResponse) {
        if (replayResponse == null) {
            throw new IllegalArgumentException("Replay response is null.");
        }
        JsonNode bodyNode = JsonSerializable.toJsonNode(replayResponse.bodySegments().orElse(new ArrayList()));
        Headers headers = Headers.of(replayResponse.headers().orElse((Map<String, String>)ImmutableMap.of()));
        return new ReplayApiResponse((ArrayNode)bodyNode, replayResponse.statusCode().orElse(0), headers);
    }

    private static String redactRequestUrl(String requestUrl) {
        String result = requestUrl.replaceAll(".*/projects/[^/]+/locations/[^/]+/", "{VERTEX_URL_PREFIX}/");
        result = result.replaceAll(".*-aiplatform.googleapis.com/[^/]+/", "{VERTEX_URL_PREFIX}/");
        result = result.replaceAll(".*aiplatform.googleapis.com/[^/]+/", "{VERTEX_URL_PREFIX}/");
        result = result.replaceAll("https://generativelanguage.googleapis.com/[^/]+", "{MLDEV_URL_PREFIX}");
        return result;
    }

    private static Map<String, String> redactRequestHeaders(Map<String, String> headers) {
        HashMap<String, String> redactedHeaders = new HashMap<String, String>();
        block12: for (Map.Entry<String, String> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            String headerValue = entry.getValue();
            switch (headerName.toLowerCase(Locale.ROOT)) {
                case "x-goog-api-key": {
                    redactedHeaders.put(headerName, "{REDACTED}");
                    continue block12;
                }
                case "user-agent": 
                case "x-goog-api-client": {
                    String redactedValue = headerValue.replaceAll("\\d+\\.\\d+\\.\\d+", "{VERSION_NUMBER}").replace("gl-java/", "{LANGUAGE_LABEL}/");
                    redactedHeaders.put(headerName, redactedValue);
                    continue block12;
                }
                case "x-goog-user-project": 
                case "authorization": {
                    continue block12;
                }
            }
            redactedHeaders.put(headerName, headerValue);
        }
        return redactedHeaders;
    }

    private static JsonNode redactRequestBody(JsonNode requestBody) {
        ObjectNode redactedNode = JsonSerializable.objectMapper.createObjectNode();
        requestBody.fields().forEachRemaining(entry -> {
            if (((JsonNode)entry.getValue()).isTextual()) {
                redactedNode.set((String)entry.getKey(), JsonSerializable.toJsonNode(((JsonNode)entry.getValue()).asText().replaceAll("projects/[^/]+/locations/[^/]+/", "{PROJECT_AND_LOCATION_PATH}/")));
            } else {
                redactedNode.set((String)entry.getKey(), (JsonNode)entry.getValue());
            }
        });
        return redactedNode;
    }

    private static Object normalizeKeyCase(Object obj) {
        if (obj instanceof Map) {
            Map originalMap = (Map)obj;
            HashMap<String, Object> normalizedMap = new HashMap<String, Object>();
            for (Map.Entry entry2 : originalMap.entrySet()) {
                String key = (String)entry2.getKey();
                normalizedMap.put(Common.snakeToCamel(key).toLowerCase(Locale.ROOT), ReplayApiClient.normalizeKeyCase(entry2.getValue()));
            }
            return normalizedMap;
        }
        if (obj instanceof List) {
            List originalList = (List)obj;
            ArrayList<Object> normalizedList = new ArrayList<Object>();
            for (Object item2 : originalList) {
                normalizedList.add(ReplayApiClient.normalizeKeyCase(item2));
            }
            return normalizedList;
        }
        if (obj instanceof JsonNode) {
            JsonNode node = (JsonNode)obj;
            if (node.isObject()) {
                ObjectNode normalizedNode = JsonSerializable.objectMapper.createObjectNode();
                node.fields().forEachRemaining(entry -> {
                    String newKey = Common.snakeToCamel((String)entry.getKey());
                    Object normalizedValue = ReplayApiClient.normalizeKeyCase(entry.getValue());
                    normalizedNode.set(newKey, JsonSerializable.toJsonNode(normalizedValue));
                });
                return normalizedNode;
            }
            if (node.isArray()) {
                ArrayNode normalizedNode = JsonSerializable.objectMapper.createArrayNode();
                node.elements().forEachRemaining(item -> normalizedNode.add(JsonSerializable.toJsonNode(ReplayApiClient.normalizeKeyCase(item))));
                return normalizedNode;
            }
            if (node.isTextual()) {
                return JsonSerializable.toJsonNode(node.asText().replaceAll("(?<=00)Z$", "\\+00:00"));
            }
        }
        return obj;
    }

    private static boolean equalsIgnoreKeyCase(Object replay, Object actual) {
        Object normalizedReplay = ReplayApiClient.normalizeKeyCase(replay);
        Object normalizedActual = ReplayApiClient.normalizeKeyCase(actual);
        return Objects.equals(normalizedReplay, normalizedActual);
    }

    private static String requestBodyToString(RequestBody requestBody) {
        if (requestBody == null) {
            return "No RequestBody";
        }
        try {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            if (contentType != null && contentType.charset() != null) {
                return buffer.readString(contentType.charset());
            }
            return buffer.readUtf8();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to convert request body to string.", e);
        }
    }
}

