/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.genai.ApiResponse;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.ApiException;
import com.google.genai.errors.GenAiIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.ResponseBody;

@ExcludeFromGeneratedCoverageReport
final class ReplayApiResponse
extends ApiResponse {
    private final ResponseBody body;
    private final int statusCode;
    private final Headers headers;
    private final ArrayNode bodySegments;

    public ReplayApiResponse(ArrayNode bodySegments, int statusCode, Headers headers) {
        this.bodySegments = bodySegments;
        this.statusCode = statusCode;
        this.headers = headers;
        if (bodySegments.size() == 0) {
            this.body = ResponseBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"");
        } else if (bodySegments.size() == 1) {
            this.body = ResponseBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JsonSerializable.toJsonString(bodySegments.get(0)));
        } else {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] newline = "\n".getBytes(StandardCharsets.UTF_8);
                for (JsonNode segment : bodySegments) {
                    outputStream.write(JsonSerializable.objectMapper.writeValueAsBytes((Object)segment));
                    outputStream.write(newline);
                }
                this.body = ResponseBody.create((byte[])outputStream.toByteArray(), (MediaType)MediaType.parse((String)"application/json"));
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to convert body segments to a JSON string.", e);
            }
        }
    }

    @Override
    public ResponseBody getBody() {
        ApiException.throwFromErrorNode(this.bodySegments, this.statusCode);
        return this.body;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void close() {
    }
}

